/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.CarFollowingModels;
import gatcomsumo.backend.GuiShapes;
import gatcomsumo.backend.LaneChangingModels;
import gatcomsumo.backend.LateralAlignment;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.VehicleClasses;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_VehicleType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import util.Colors;
import util.Util;

public class DlgVehicleType
extends JDialog
implements ActionListener,
WindowListener {
    MyFrame f;
    SUMO sumo;
    VehicleType vehicletype;
    Panel_VehicleType pVehicleType;
    JButton bOk;
    JButton bCancel;
    private boolean canceled = false;

    public DlgVehicleType(MyFrame f, SUMO sumo, String title, VehicleType vehicletype) {
        super(f, title, true);
        this.sumo = sumo;
        this.vehicletype = vehicletype;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.pVehicleType = new Panel_VehicleType(f, sumo);
        this.add((Component)this.pVehicleType, "Center");
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.bOk);
        pButtons.add(this.bCancel);
        this.object2components();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(f);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.components2object();
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public void object2components() {
        this.pVehicleType.txtID.setText(this.vehicletype.id);
        if (this.vehicletype.color != null) {
            this.pVehicleType.cbColor.setSelectedItem((Object)this.vehicletype.color);
        }
        if (this.vehicletype.vClass != null) {
            this.pVehicleType.cbClass.setSelectedItem((Object)this.vehicletype.vClass);
        }
        if (this.vehicletype.guishape != null) {
            this.pVehicleType.cbGUIShape.setSelectedItem((Object)this.vehicletype.guishape);
        }
        this.pVehicleType.txtLength.setText(this.vehicletype.length + "");
        this.pVehicleType.txtGUIWidth.setText(this.vehicletype.width + "");
        this.pVehicleType.txtGUIImageFile.setText(this.vehicletype.guiimgFile);
        this.pVehicleType.txtAccel.setText(this.vehicletype.accel + "");
        this.pVehicleType.txtDecel.setText(this.vehicletype.decel + "");
        this.pVehicleType.txtMaxSpeed.setText(this.vehicletype.maxSpeed + "");
        this.pVehicleType.txtSpeedFactor.setText(this.vehicletype.speedFactor + "");
        this.pVehicleType.txtSpeedDev.setText(this.vehicletype.speedDev + "");
        this.pVehicleType.txtSigma.setText(this.vehicletype.sigma + "");
        this.pVehicleType.txtTau.setText(this.vehicletype.tau + "");
        this.pVehicleType.txtImpatience.setText(this.vehicletype.impatience + "");
        this.pVehicleType.txtMinGap.setText(this.vehicletype.minGap + "");
        this.pVehicleType.txtPersonCapacity.setText(this.vehicletype.personCapacity + "");
        this.pVehicleType.txtBoardingDuration.setText(this.vehicletype.boardingDuration + "");
        this.pVehicleType.txtContainerCapacity.setText(this.vehicletype.containerCapacity + "");
        this.pVehicleType.txtLoadingDuration.setText(this.vehicletype.loadingDuration + "");
        if (this.vehicletype.laneChangeModel != null) {
            this.pVehicleType.cbLaneChangeModel.setSelectedItem((Object)this.vehicletype.laneChangeModel);
        }
        if (this.vehicletype.carFollowModel != null) {
            this.pVehicleType.cbCarFollowModel.setSelectedItem((Object)this.vehicletype.carFollowModel);
        }
        if (this.vehicletype.latAlignment != null) {
            this.pVehicleType.cbLatAlignment.setSelectedItem((Object)this.vehicletype.latAlignment);
        }
        this.pVehicleType.txtMinGapLat.setText(this.vehicletype.minGapLat + "");
        this.pVehicleType.txtMaxSpeedLat.setText(this.vehicletype.maxSpeedLat + "");
    }

    public void components2object() {
        this.vehicletype.id = this.pVehicleType.txtID.getText();
        this.vehicletype.vClass = (VehicleClasses)((Object)this.pVehicleType.cbClass.getSelectedItem());
        this.vehicletype.color = (Colors)((Object)this.pVehicleType.cbColor.getSelectedItem());
        this.vehicletype.guishape = (GuiShapes)((Object)this.pVehicleType.cbGUIShape.getSelectedItem());
        this.vehicletype.length = Util.parseDouble(this.pVehicleType.txtLength.getText());
        this.vehicletype.width = Util.parseDouble(this.pVehicleType.txtGUIWidth.getText());
        this.vehicletype.guiimgFile = this.pVehicleType.txtGUIImageFile.getText();
        this.vehicletype.accel = Util.parseDouble(this.pVehicleType.txtAccel.getText());
        this.vehicletype.decel = Util.parseDouble(this.pVehicleType.txtDecel.getText());
        this.vehicletype.maxSpeed = Util.parseDouble(this.pVehicleType.txtMaxSpeed.getText());
        this.vehicletype.speedFactor = Util.parseDouble(this.pVehicleType.txtSpeedFactor.getText());
        this.vehicletype.speedDev = Util.parseDouble(this.pVehicleType.txtSpeedDev.getText());
        this.vehicletype.sigma = Util.parseDouble(this.pVehicleType.txtSigma.getText());
        this.vehicletype.tau = Util.parseDouble(this.pVehicleType.txtTau.getText());
        this.vehicletype.impatience = Util.parseDouble(this.pVehicleType.txtImpatience.getText());
        this.vehicletype.minGap = Util.parseDouble(this.pVehicleType.txtMinGap.getText());
        this.vehicletype.personCapacity = Util.parseInt(this.pVehicleType.txtPersonCapacity.getText());
        this.vehicletype.boardingDuration = Util.parseDouble(this.pVehicleType.txtBoardingDuration.getText());
        this.vehicletype.containerCapacity = Util.parseInt(this.pVehicleType.txtContainerCapacity.getText());
        this.vehicletype.loadingDuration = Util.parseDouble(this.pVehicleType.txtLoadingDuration.getText());
        this.vehicletype.laneChangeModel = (LaneChangingModels)((Object)this.pVehicleType.cbLaneChangeModel.getSelectedItem());
        this.vehicletype.carFollowModel = (CarFollowingModels)((Object)this.pVehicleType.cbCarFollowModel.getSelectedItem());
        this.vehicletype.latAlignment = (LateralAlignment)((Object)this.pVehicleType.cbLatAlignment.getSelectedItem());
        this.vehicletype.minGapLat = Util.parseInt(this.pVehicleType.txtMinGapLat.getText());
        this.vehicletype.maxSpeedLat = Util.parseDouble(this.pVehicleType.txtMaxSpeedLat.getText());
    }
}

