/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Route;
import gatcomsumo.backend.Routes;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Vehicle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import util.Colors;
import util.Util;

public class DlgVehicle
extends JDialog
implements ActionListener,
WindowListener {
    private MyFrame f;
    private SUMO sumo;
    private Vehicle vehicle;
    private Panel_Vehicle pVehicle;
    private JButton bOk;
    private JButton bCancel;
    private boolean canceled = false;

    public DlgVehicle(MyFrame f, SUMO sumo, String title, Vehicle vehicle) {
        super(f, title, true);
        this.sumo = sumo;
        this.vehicle = vehicle;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.pVehicle = new Panel_Vehicle(f, sumo);
        this.add((Component)this.pVehicle, "Center");
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.bOk);
        pButtons.add(this.bCancel);
        this.object2components();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(f);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean routesModified() {
        return this.pVehicle.routesMod;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.components2object();
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public void object2components() {
        int index;
        this.pVehicle.txtID.setText(this.vehicle.id);
        if (this.vehicle.type != null) {
            this.pVehicle.cbType.setSelectedItem(this.vehicle.type);
        }
        if (this.vehicle.color != null) {
            this.pVehicle.cbColor.setSelectedItem((Object)this.vehicle.color);
        }
        if (this.vehicle.route != null) {
            this.pVehicle.cbRoute.setSelectedItem(this.vehicle.route);
            this.pVehicle.txtRouteEdges.setText(this.vehicle.route.getEdges());
        } else {
            this.pVehicle.cbRoute.setSelectedItem(Routes.routeNull);
        }
        this.pVehicle.pDepartTime.setSeconds(this.vehicle.depart);
        if (this.vehicle.departlane >= 0) {
            this.pVehicle.cbDepartLane1.setState(true);
            this.pVehicle.txtDepartLane.setEnabled(true);
            this.pVehicle.txtDepartLane.setText("" + this.vehicle.departlane);
        } else {
            this.pVehicle.cbDepartLane2.setState(true);
            this.pVehicle.txtDepartLane.setEnabled(false);
            index = -1 * this.vehicle.departlane;
            if (index < this.pVehicle.cbDepartLaneOther.getItemCount()) {
                this.pVehicle.cbDepartLaneOther.setSelectedIndex(index);
            }
        }
        if (this.vehicle.departpos >= 0.0) {
            this.pVehicle.cbDepartPos1.setState(true);
            this.pVehicle.txtDepartPos.setEnabled(true);
            this.pVehicle.txtDepartPos.setText("" + this.vehicle.departpos);
        } else {
            this.pVehicle.cbDepartPos2.setState(true);
            this.pVehicle.txtDepartPos.setEnabled(false);
            index = (int)(-1.0 * this.vehicle.departpos);
            if (index < this.pVehicle.cbDepartPosOther.getItemCount()) {
                this.pVehicle.cbDepartPosOther.setSelectedIndex(index);
            }
        }
        if (this.vehicle.departspeed >= 0.0) {
            this.pVehicle.cbDepartSpeed1.setState(true);
            this.pVehicle.txtDepartSpeed.setEnabled(true);
            this.pVehicle.txtDepartSpeed.setText("" + this.vehicle.departspeed);
        } else {
            this.pVehicle.cbDepartSpeed2.setState(true);
            this.pVehicle.txtDepartSpeed.setEnabled(false);
            index = (int)(-1.0 * this.vehicle.departspeed);
            if (index < this.pVehicle.cbDepartSpeedOther.getItemCount()) {
                this.pVehicle.cbDepartSpeedOther.setSelectedIndex(index);
            }
        }
    }

    public void components2object() {
        this.vehicle.id = this.pVehicle.txtID.getText();
        this.vehicle.type = (VehicleType)this.pVehicle.cbType.getSelectedItem();
        this.vehicle.color = (Colors)((Object)this.pVehicle.cbColor.getSelectedItem());
        Route route = (Route)this.pVehicle.cbRoute.getSelectedItem();
        if (route == Routes.routeNull) {
            route = null;
        }
        if (route != this.vehicle.route) {
            this.vehicle.setRoute(route);
        }
        this.vehicle.depart = this.pVehicle.pDepartTime.getSeconds();
        this.vehicle.departlane = this.pVehicle.cbDepartLane1.getState() ? Util.parseInt(this.pVehicle.txtDepartLane.getText()) : -1 * this.pVehicle.cbDepartLaneOther.getSelectedIndex();
        this.vehicle.departpos = this.pVehicle.cbDepartPos1.getState() ? Util.parseDouble(this.pVehicle.txtDepartPos.getText()) : (double)(-1 * this.pVehicle.cbDepartPosOther.getSelectedIndex());
        this.vehicle.departspeed = this.pVehicle.cbDepartSpeed1.getState() ? Util.parseDouble(this.pVehicle.txtDepartSpeed.getText()) : (double)(-1 * this.pVehicle.cbDepartSpeedOther.getSelectedIndex());
    }
}

