/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Colors;
import util.Util;

public class DlgTripsVehicles
extends JDialog
implements ActionListener,
WindowListener,
ItemListener {
    private MyFrame f;
    private SUMO sumo;
    ArrayList<Route> routes;
    private static final String[] VEHICLES_VS_FLOWS = new String[]{"Vehicles", "Flows"};
    private JLabel lblRoute;
    private JLabel lblGenerate;
    private JLabel lblGenerateID;
    private JLabel lblGenerateID_n;
    private JLabel lblType;
    private JLabel lblColor;
    private JLabel lblFlowNumberVehicles;
    private JLabel lblFlowFrecuency;
    private JLabel lblDepartTime;
    private JLabel lblDepartIncr;
    private JComboBox cbRoute;
    private JComboBox cbGenerate;
    private JComboBox cbType;
    private JComboBox cbColor;
    private JComboBox cbFlowFrecuency;
    private JTextField txtGenerateNum;
    private JTextField txtGenerateID;
    private JTextField txtGenerateID_n;
    private JTextField txtFlowNumberVehicles;
    private JTextField txtFlowFrecuency;
    private JTextField txtDepartIncr;
    private Panel_Time pDepartTime;
    private JButton pbAdd;
    private JButton pbCancel;
    public boolean canceled = false;

    public DlgTripsVehicles(MyFrame f, SUMO sumo, String title) {
        super(f, title, true);
        this.f = f;
        this.sumo = sumo;
        this.routes = sumo.trafficDemand.routes.list;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        this.lblRoute = new JLabel("First route to assign:");
        this.cbRoute = new JComboBox<Object>(sumo.trafficDemand.routes.list.toArray());
        this.cbRoute.addItemListener(this);
        this.cbRoute.setToolTipText("First route to assign to each vehicle/flow");
        p1.setLayout(new FlowLayout(0));
        p1.add(this.lblRoute);
        p1.add(this.cbRoute);
        JPanel p2 = new JPanel();
        this.lblGenerate = new JLabel("Generate:");
        this.txtGenerateNum = new JTextField("" + this.routes.size(), 3);
        this.cbGenerate = new JComboBox<String>(VEHICLES_VS_FLOWS);
        this.cbGenerate.addItemListener(this);
        this.lblGenerateID = new JLabel("ID:");
        this.txtGenerateID = new JTextField("", 8);
        this.lblGenerateID_n = new JLabel("-");
        this.txtGenerateID_n = new JTextField("0", 3);
        p2.setLayout(new FlowLayout(0));
        p2.add(this.lblGenerate);
        p2.add(this.txtGenerateNum);
        p2.add(this.cbGenerate);
        p2.add(this.lblGenerateID);
        p2.add(this.txtGenerateID);
        p2.add(this.lblGenerateID_n);
        p2.add(this.txtGenerateID_n);
        JPanel p3 = new JPanel();
        this.lblType = new JLabel("Type:");
        this.cbType = new JComboBox<Object>(sumo.trafficDemand.vehicletypes.list.toArray());
        VehicleType defaultType = sumo.trafficDemand.vehicletypes.search("passenger");
        this.cbType.setSelectedItem(defaultType);
        this.lblColor = new JLabel("Color:");
        this.cbColor = new JComboBox<Colors>(Colors.values());
        this.cbColor.setSelectedItem((Object)Colors.MAGENTA);
        this.lblFlowNumberVehicles = new JLabel("Num.Vehicles:");
        this.txtFlowNumberVehicles = new JTextField("3", 3);
        this.txtFlowNumberVehicles.setToolTipText("Total number of vehicles of the flow");
        p3.setLayout(new FlowLayout(0));
        p3.add(this.lblType);
        p3.add(this.cbType);
        p3.add(this.lblColor);
        p3.add(this.cbColor);
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(0));
        this.lblFlowFrecuency = new JLabel("Frecuency:");
        this.cbFlowFrecuency = new JComboBox<String>(Flow.FREQUENCY_FORMS);
        this.cbFlowFrecuency.setToolTipText("Number of vehicles per hour vs. Period for inserting vs. Probability for emitting a vehicle each second; if used, the end parameter will be ignored.");
        this.txtFlowFrecuency = new JTextField("0", 3);
        this.txtFlowFrecuency.setToolTipText("Parameter for frecuency selected; if used, the end parameter will be ignored.");
        p4.add(this.lblFlowNumberVehicles);
        p4.add(this.txtFlowNumberVehicles);
        p4.add(this.lblFlowFrecuency);
        p4.add(this.cbFlowFrecuency);
        p4.add(this.txtFlowFrecuency);
        JPanel p5 = new JPanel();
        this.lblDepartTime = new JLabel("Depart (hh:mm:ss:ts):");
        this.pDepartTime = new Panel_Time();
        p5.setLayout(new FlowLayout(0));
        p5.add(this.lblDepartTime);
        p5.add(this.pDepartTime);
        JPanel p6 = new JPanel();
        p6.setLayout(new FlowLayout(0));
        this.lblDepartIncr = new JLabel("Increment between vehicles/flows (secs.):");
        this.txtDepartIncr = new JTextField("0.01", 5);
        p6.add(this.lblDepartIncr);
        p6.add(this.txtDepartIncr);
        JPanel pCentro = new JPanel();
        pCentro.setLayout(new GridLayout(6, 1));
        pCentro.add(p1);
        pCentro.add(p2);
        pCentro.add(p3);
        pCentro.add(p4);
        pCentro.add(p5);
        pCentro.add(p6);
        JPanel pButtons = new JPanel();
        this.pbAdd = new JButton("Add Vehicles/Flows");
        this.pbAdd.setToolTipText("Create vehicles/flows and assign routes to them");
        this.pbAdd.addActionListener(this);
        this.pbCancel = new JButton("Cancel");
        this.pbCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.pbAdd);
        pButtons.add(this.pbCancel);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentro, "Center");
        this.add((Component)pButtons, "South");
        this.updateNumberOfVehicles();
        this.updateFirstID();
        this.updateBeginTime();
        this.enableComponents();
        VehicleType type = sumo.trafficDemand.vehicletypes.search("passenger");
        if (type != null) {
            this.cbType.setSelectedItem(type);
        }
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(f);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbAdd) {
            int routeIndex = this.cbRoute.getSelectedIndex();
            int n = Util.parseInt(this.txtGenerateNum.getText());
            boolean flows = this.cbGenerate.getSelectedIndex() == 1;
            String vehicleIDPrefix = this.txtGenerateID.getText();
            int vehicleIDBaseIndex = Util.parseInt(this.txtGenerateID_n.getText());
            VehicleType type = (VehicleType)this.cbType.getSelectedItem();
            Colors color = (Colors)((Object)this.cbColor.getSelectedItem());
            int flowNumVehicles = Util.parseInt(this.txtFlowNumberVehicles.getText());
            int flowIndexFreq = this.cbFlowFrecuency.getSelectedIndex();
            double flowValorFreq = Util.parseDouble(this.txtFlowFrecuency.getText());
            double depart = this.pDepartTime.getSeconds();
            double departIncr = Util.parseDouble(this.txtDepartIncr.getText());
            for (int i = 0; i < n; ++i) {
                String id = vehicleIDPrefix + "-" + (vehicleIDBaseIndex + i);
                Route route = this.routes.get((routeIndex + i) % this.routes.size());
                if (!flows) {
                    Vehicle vehicle = new Vehicle(id, type, color);
                    vehicle.setRoute(route);
                    vehicle.setDepart(depart);
                    depart += departIncr;
                    depart = (double)Math.round(depart * 10000.0) / 10000.0;
                    this.sumo.trafficDemand.vehicles.list.add(vehicle);
                    continue;
                }
                Flow flow = new Flow(id, type, color, flowNumVehicles);
                flow.setRoute(route);
                flow.setBegin(depart);
                flow.probability = -1.0;
                flow.period = -1.0;
                flow.vehsPerHour = -1.0;
                if (flowValorFreq > 0.0) {
                    switch (flowIndexFreq) {
                        case 0: {
                            flow.vehsPerHour = flowValorFreq;
                            break;
                        }
                        case 1: {
                            flow.period = flowValorFreq;
                            break;
                        }
                        case 2: {
                            flow.probability = flowValorFreq;
                            break;
                        }
                    }
                }
                this.sumo.trafficDemand.flows.list.add(flow);
            }
            if (!flows) {
                this.f.pTrafficDemands.pVehicles.update();
            } else {
                this.f.pTrafficDemands.pFlows.update();
            }
            this.sumo.trafficDemand.setChanged(true);
            JOptionPane.showMessageDialog(this, (flows ? "Flow(s)" : "Vehicle(s)") + " added succesfully! (" + n + ")", "Generate vehicles/flows", 1);
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.pbCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbRoute) {
            this.updateNumberOfVehicles();
        } else if (e.getSource() == this.cbGenerate) {
            this.updateFirstID();
            this.enableComponents();
        }
    }

    private void enableComponents() {
        boolean flows = this.cbGenerate.getSelectedIndex() == 1;
        this.lblFlowNumberVehicles.setEnabled(flows);
        this.txtFlowNumberVehicles.setEnabled(flows);
        this.lblFlowFrecuency.setEnabled(flows);
        this.cbFlowFrecuency.setEnabled(flows);
        this.txtFlowFrecuency.setEnabled(flows);
    }

    private void updateNumberOfVehicles() {
        int index = this.cbRoute.getSelectedIndex();
        int n = this.cbRoute.getItemCount() - index;
        this.txtGenerateNum.setText("" + n);
    }

    private void updateFirstID() {
        boolean vehicles = this.cbGenerate.getSelectedIndex() == 0;
        String prefix = vehicles ? "vehicle" : "flow";
        int index = 0;
        if (vehicles) {
            prefix = this.sumo.trafficDemand.vehicles.getLastPrefix();
            index = this.sumo.trafficDemand.vehicles.getLastIndex(prefix) + 1;
        } else {
            prefix = this.sumo.trafficDemand.flows.getLastPrefix();
            index = this.sumo.trafficDemand.flows.getLastIndex(prefix) + 1;
        }
        this.txtGenerateID.setText(prefix);
        this.txtGenerateID_n.setText("" + index);
    }

    private void updateBeginTime() {
        double vehiclesMaxDepartTime = this.sumo.trafficDemand.vehicles.getMaxDepartTime();
        double flowsMaxBegin = this.sumo.trafficDemand.flows.getMaxBeginTime();
        double begin = Math.max(vehiclesMaxDepartTime, flowsMaxBegin);
        this.pDepartTime.setSeconds(begin += 1.0);
    }
}

