/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_GenericList;
import gatcomsumo.frontend.Panel_TripsFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgTrips
extends JDialog
implements ActionListener,
WindowListener,
Panel_GenericList.MyListener {
    private MyFrame f;
    private SUMO sumo;
    ArrayList<Route> routes;
    ArrayList<Route> routesList;
    private Panel_TripsFilter pFilter;
    private Panel_GenericList pRoutes;
    private Panel_GenericList pEdges;
    private JLabel lblPlayground;
    private JTextField txtPlayground;
    private JButton pbAddRoutes;
    private JButton pbCancel;
    public boolean canceled = false;

    public DlgTrips(MyFrame f, SUMO sumo, String title, ArrayList<Route> routes) {
        super(f, title, true);
        this.f = f;
        this.sumo = sumo;
        this.routes = routes;
        this.routesList = new ArrayList();
        JPanel panel = (JPanel)this.getContentPane();
        this.pFilter = new Panel_TripsFilter(f, sumo, this, f.pTrafficDemands.pTrips.pFilter);
        JPanel pCentro = new JPanel();
        JPanel pCentroCentro = new JPanel();
        this.pRoutes = new Panel_GenericList(f, " Routes ", sumo, false, false, false, false, false);
        this.pEdges = new Panel_GenericList(f, " Edges ", sumo, false, false, false, false, false);
        pCentroCentro.setLayout(new GridLayout(1, 2));
        pCentroCentro.add(this.pRoutes);
        pCentroCentro.add(this.pEdges);
        JPanel pCentroSur = new JPanel();
        this.lblPlayground = new JLabel("Playground size:");
        this.txtPlayground = new JTextField("", 50);
        this.txtPlayground.setEditable(false);
        pCentroSur.setLayout(new BorderLayout());
        pCentroSur.add((Component)this.lblPlayground, "West");
        pCentroSur.add((Component)this.txtPlayground, "Center");
        pCentro.setLayout(new BorderLayout());
        pCentro.add((Component)pCentroCentro, "Center");
        pCentro.add((Component)pCentroSur, "South");
        JPanel pButtons = new JPanel();
        this.pbAddRoutes = new JButton("Add selected route(s)");
        this.pbAddRoutes.setToolTipText("Append the selected routes to the routes tab");
        this.pbAddRoutes.addActionListener(this);
        this.pbCancel = new JButton("Cancel");
        this.pbCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.pbAddRoutes);
        pButtons.add(this.pbCancel);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.pFilter, "North");
        panel.add((Component)pCentro, "Center");
        panel.add((Component)pButtons, "South");
        this.updateRoutes();
        this.pRoutes.list.setMultipleMode(true);
        this.pRoutes.selectAll();
        this.pRoutes.addListener(this);
        this.computePlaygroundSize(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.setSize(600, 400);
        this.setLocationRelativeTo(f);
    }

    private int updateRoutes() {
        Rectangle2D.Double bbox_rect = this.sumo.network.buildBBOX_margin(this.sumo, this.pFilter.getMargin());
        this.pRoutes.list.removeAll();
        this.routesList.clear();
        for (Route route : this.routes) {
            boolean ok = this.pFilter.checkRoute(route, bbox_rect);
            if (!ok) continue;
            this.pRoutes.addItem(route.toString());
            this.routesList.add(route);
        }
        int nRoutes = this.pRoutes.list.getItemCount();
        if (nRoutes > 0) {
            this.pRoutes.list.select(0);
            this.updateEdges(0);
        } else {
            this.updateEdges(-1);
        }
        this.pRoutes.setTitle(" Routes (" + nRoutes + ") ");
        return nRoutes;
    }

    private int updateEdges() {
        int index = this.pRoutes.list.getSelectedIndex();
        return this.updateEdges(index);
    }

    private int updateEdges(int index) {
        this.pEdges.list.removeAll();
        if (index >= 0) {
            Route route = this.routesList.get(index);
            for (Edge edge : route.edges) {
                this.pEdges.addItem(edge.toString());
            }
        }
        int nEdges = this.pEdges.list.getItemCount();
        this.pEdges.setTitle(" Edges (" + nEdges + ") ");
        return nEdges;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Route route = null;
        if (e.getSource() == this.pFilter.pbFilterApply) {
            int n = this.updateRoutes();
        } else if (e.getSource() == this.pbAddRoutes) {
            int nOk = 0;
            int n = this.routes.size();
            for (int i = 0; i < n; ++i) {
                if (!this.pRoutes.list.isIndexSelected(i)) continue;
                route = this.routesList.get(i);
                this.sumo.trafficDemand.routes.list.add(route);
                ++nOk;
            }
            if (nOk > 0) {
                String playground = this.computePlaygroundSize(true);
                JOptionPane.showMessageDialog(this, "Route(s) added succesfully! (" + nOk + "/" + n + ") \n\nThe playground size of the scenario should greater or equal than:\n" + playground + "\n\nNow you can create vehicles automatically.", "Trips", 1);
            }
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.pbCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public String computePlaygroundSize(boolean all) {
        Rectangle2D.Double bbox_sumo = this.sumo.network.location.getRectangle_bbox_conv();
        bbox_sumo.x = 9999999.0;
        bbox_sumo.y = 9999999.0;
        bbox_sumo.width = -9999999.0;
        bbox_sumo.height = -9999999.0;
        int n = this.routesList.size();
        for (int i = 0; i < n; ++i) {
            if (!all && !this.pRoutes.list.isIndexSelected(i)) continue;
            Route route = this.routesList.get(i);
            route.getRectangle(bbox_sumo);
        }
        Point2D.Double p1SUMO = new Point2D.Double(bbox_sumo.x, bbox_sumo.y);
        Point2D.Double p2SUMO = new Point2D.Double(bbox_sumo.x + bbox_sumo.width, bbox_sumo.x + bbox_sumo.height);
        Point2D.Double p1OMNET = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2OMNET = new Point2D.Double(0.0, 0.0);
        this.sumo.network.sumo2omnet(p1SUMO, p1OMNET);
        this.sumo.network.sumo2omnet(p2SUMO, p2OMNET);
        double width = Math.abs(p2OMNET.x - p1OMNET.x);
        double height = Math.abs(p2OMNET.y - p1OMNET.y);
        String playground = "*.playgroundSizeX=" + String.format("%.2f", width) + "m\n*.playgroundSizeY=" + String.format("%.2f", height) + "m\n*.playgroundSizeZ=0m";
        this.txtPlayground.setText("X: " + String.format("%.2f", width) + " Y: " + String.format("%.2f", height));
        return playground;
    }

    @Override
    public void addItem(Panel_GenericList.MyEvent e) {
    }

    @Override
    public void removeItem(Panel_GenericList.MyEvent e, int index) {
    }

    @Override
    public void editItem(Panel_GenericList.MyEvent e, int index) {
    }

    @Override
    public void selectItem(Panel_GenericList.MyEvent e, int index) {
        String playground = this.computePlaygroundSize(false);
        if (index >= 0) {
            this.updateEdges(index);
        }
    }

    @Override
    public boolean load(Panel_GenericList.MyEvent e) {
        return false;
    }

    @Override
    public boolean save(Panel_GenericList.MyEvent e) {
        return false;
    }
}

