/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Conv;
import util.Util;
import util.gui.MyTextAreaScrollable;
import wireless.Units_Frequency;

public class DlgThermalNoise
extends JDialog
implements ActionListener {
    protected static final double K_BOLTZMANN = 1.38064852 * Math.pow(10.0, -23.0);
    private static final DecimalFormat f4dec = new DecimalFormat("#,##0.0000");
    private static final String[] TEMP_UNITS = new String[]{"Celsius (C\u00ba)", "Fahrenheit", "Kelvin"};
    MyFrame f;
    private JLabel lblFrequency;
    private JLabel lblTemperature;
    private JLabel lblThermalNoise;
    private JTextField txtFrequency;
    private JTextField txtTemperature;
    private JTextField txtThermalNoise;
    private JComboBox cbFrequencyUnits;
    private JComboBox cbTempUnits;
    private MyTextAreaScrollable txtOmnetpp;
    private JButton pbCalculate;
    private JButton pbClose;
    private double frequency;
    private double frequency_mkz;
    private double temp;
    private double temp_kelvin;
    private Units_Frequency f_units;

    public DlgThermalNoise(MyFrame f, double frequency, Units_Frequency f_units) {
        super(f, "Thermal noise", true);
        this.f = f;
        this.lblFrequency = new JLabel("Frequency:");
        this.txtFrequency = new JTextField("5.890", 10);
        this.txtFrequency.setToolTipText("Frequency band of the carrier in MHz (e.g. 2.4 GHz is 2400 MHz)");
        this.cbFrequencyUnits = new JComboBox();
        Units_Frequency.fill(this.cbFrequencyUnits);
        this.cbFrequencyUnits.setSelectedItem("GHz");
        this.cbFrequencyUnits.setSelectedIndex(3);
        this.lblTemperature = new JLabel("Temperature:");
        this.txtTemperature = new JTextField("20", 10);
        this.txtTemperature.setToolTipText("Temperature");
        this.cbTempUnits = new JComboBox<String>(TEMP_UNITS);
        this.cbTempUnits.setSelectedIndex(0);
        this.lblThermalNoise = new JLabel("Thermal Noise (dBm):");
        this.txtThermalNoise = new JTextField("", 10);
        this.txtThermalNoise.setToolTipText("Thermal Noise");
        this.txtThermalNoise.setEditable(false);
        JPanel pOeste = new JPanel();
        pOeste.setLayout(new GridLayout(3, 1));
        pOeste.add(this.lblFrequency);
        pOeste.add(this.lblTemperature);
        pOeste.add(this.lblThermalNoise);
        JPanel pCentro = new JPanel();
        pCentro.setLayout(new GridLayout(3, 1));
        pCentro.add(this.txtFrequency);
        pCentro.add(this.txtTemperature);
        pCentro.add(this.txtThermalNoise);
        JPanel pEste = new JPanel();
        pEste.setLayout(new GridLayout(3, 1));
        pEste.add(this.cbFrequencyUnits);
        pEste.add(this.cbTempUnits);
        pEste.add(new JLabel("  dBv"));
        JPanel pCentro1 = new JPanel();
        pCentro1.setLayout(new BorderLayout());
        pCentro1.add((Component)pOeste, "West");
        pCentro1.add((Component)pCentro, "Center");
        pCentro1.add((Component)pEste, "East");
        this.txtOmnetpp = new MyTextAreaScrollable();
        this.txtOmnetpp.setEditable(false);
        JPanel pCentroTotal = new JPanel();
        pCentroTotal.setLayout(new GridLayout(2, 1));
        pCentroTotal.add(pCentro1);
        pCentroTotal.add(this.txtOmnetpp);
        JPanel pSur = new JPanel();
        this.pbCalculate = new JButton("Calculate");
        this.pbCalculate.addActionListener(this);
        this.pbClose = new JButton("Close");
        this.pbClose.addActionListener(this);
        pSur.setLayout(new FlowLayout());
        pSur.add(this.pbCalculate);
        pSur.add(this.pbClose);
        this.setLayout(new BorderLayout());
        this.add((Component)pCentroTotal, "Center");
        this.add((Component)pSur, "South");
        this.calculate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgThermalNoise.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setSize(400, 250);
        this.setLocationRelativeTo(f);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbCalculate) {
            this.calculate();
        } else if (e.getSource() == this.pbClose) {
            this.dispose();
        }
    }

    public static double thermalNoise1(double b, double t) {
        double noise = K_BOLTZMANN * b * t;
        return noise;
    }

    public static double thermalNoise2(double b, double t) {
        double res_ohm = 50.0;
        double noise = Math.sqrt(4.0 * K_BOLTZMANN * b * t * res_ohm);
        return noise;
    }

    private void calculate() {
        double bandwidth = Util.parseDouble(this.txtFrequency.getText());
        this.temp = Util.parseDouble(this.txtTemperature.getText());
        Units_Frequency b_units = (Units_Frequency)((Object)this.cbFrequencyUnits.getSelectedItem());
        double bandwidth_hz = bandwidth / b_units.getConv2Hz();
        switch (this.cbTempUnits.getSelectedIndex()) {
            case 0: {
                this.temp_kelvin = Conv.celsius_to_kelvin(this.temp);
                break;
            }
            case 1: {
                this.temp_kelvin = Conv.fahrenheit_to_kelvin(this.temp);
                break;
            }
            case 2: {
                this.temp_kelvin = this.temp;
                break;
            }
        }
        double noise = DlgThermalNoise.thermalNoise2(bandwidth_hz, this.temp_kelvin);
        double noise_db = 20.0 * Math.log10(noise);
        this.txtThermalNoise.setText(f4dec.format(noise_db));
        this.updateParameters(noise_db);
    }

    private void updateParameters(double noise_db) {
        String omnetpp = "# Thermal Noise\n";
        omnetpp = omnetpp + "*.**.nic.phy80211p.useThermalNoise = false\n";
        omnetpp = omnetpp + "*.**.nic.phy80211p.thermalNoise = " + Util.doubleWithDotPoint(f4dec.format(noise_db)) + " dBm\n\n";
        this.txtOmnetpp.setText(omnetpp);
    }
}

