/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.frontend.PanelDirection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class DlgSelect
extends JDialog
implements WindowListener,
ActionListener,
ItemListener {
    private Window owner;
    private Object obj = null;
    private JComboBox list;
    private JPanel pList;
    private PanelDirection pDirection;
    private JButton bOk;
    private JButton bCancel;
    private Edge lastEdge;

    public DlgSelect(Window owner, String title, Edge lastEdge, ArrayList listobjs) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.owner = owner;
        this.lastEdge = lastEdge;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 10, 5, 10));
        TitledBorder b = new TitledBorder(title);
        this.pList = new JPanel();
        this.pList.setLayout(new BorderLayout());
        this.pList.setBorder(b);
        this.list = new JComboBox<Object>(listobjs.toArray());
        this.list.addItemListener(this);
        this.pList.add((Component)this.list, "Center");
        panel.add((Component)this.pList, "Center");
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.bOk);
        pButtons.add(this.bCancel);
        if (listobjs.size() > 0) {
            this.list.setSelectedIndex(0);
            Object obj = listobjs.get(0);
            if (obj instanceof Edge) {
                this.pDirection = new PanelDirection();
                this.pList.add((Component)this.pDirection, "South");
                this.updateBearing();
            }
        }
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public Object getObject() {
        return this.obj;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.obj = this.list.getSelectedItem();
        }
        this.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.list) {
            this.updateBearing();
        }
    }

    private void updateBearing() {
        Object obj = this.list.getSelectedItem();
        if (obj instanceof Edge) {
            Edge edge = (Edge)obj;
            this.updateAzimuthSelectedEdge(edge);
        }
    }

    private void updateAzimuthSelectedEdge(Edge edge) {
        String navInstr = "";
        double azimuth1 = edge.getAzimuth();
        navInstr = this.lastEdge == null ? "" : this.lastEdge.getNavInstructions(edge);
        this.pDirection.setAzimuth(azimuth1, navInstr);
    }

    public String getNavigationInstr() {
        String s = this.pDirection.getNavigationInstr();
        return s;
    }
}

