/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Route;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DlgRoute
extends JDialog
implements ActionListener,
WindowListener {
    private MyFrame f;
    private SUMO sumo;
    private Route route;
    private Panel_Route pRoute;
    private JButton bOk;
    private JButton bCancel;
    private boolean canceled = false;

    public DlgRoute(MyFrame f, SUMO sumo, String title, Route route) {
        super(f, title, true);
        this.f = f;
        this.sumo = sumo;
        this.route = route;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.pRoute = new Panel_Route(f, this, sumo, route);
        this.add((Component)this.pRoute, "Center");
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.bOk);
        pButtons.add(this.bCancel);
        this.object2components();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(f);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean vehiclesModified() {
        return this.pRoute.vehiclesMod;
    }

    public boolean flowsModified() {
        return this.pRoute.flowsMod;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.components2object();
            Edge edge = this.route.isUnconnected();
            if (edge != null) {
                JOptionPane.showMessageDialog(this, "This route is unconnected after the edge: " + edge + "\nRoutes have to be connected, but you can use it with the --ignore-route-errors option.", "Route is broken", 0);
            }
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public void object2components() {
        this.pRoute.object2components();
    }

    public void components2object() {
        this.pRoute.components2object();
    }
}

