/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.NetworkBBox;
import gatcomsumo.frontend.Panel_BBox;
import gatcomsumo.osm.OSM_Exception;
import gatcomsumo.osm.OSM_ExportFormat;
import gatcomsumo.osm.OpenStreetMap;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.Util;
import util.gps.GeodeticCoordinates;
import util.gps.UTMCoordinates;

public class DlgOSMDownload
extends JDialog
implements ActionListener {
    private static final int TIMEOUT = 0;
    private OpenStreetMap osm;
    private JFrame f;
    private Panel_BBox pBoundingBox;
    private JLabel lblFileName;
    private JLabel lblFormat;
    private JTextField txtFileName;
    private JComboBox cbFormat;
    private JButton pbDownload;
    private JButton pbCancel;
    private boolean canceled;

    public DlgOSMDownload(JFrame f, OpenStreetMap osm, String name) {
        super(f, "OpenStreetMap", true);
        this.f = f;
        this.osm = osm;
        JPanel pNorte = new JPanel();
        this.lblFileName = new JLabel("File name:");
        this.txtFileName = new JTextField(name, 20);
        this.lblFormat = new JLabel("Format:");
        this.cbFormat = new JComboBox<OSM_ExportFormat>(OSM_ExportFormat.values());
        pNorte.setLayout(new FlowLayout(0));
        pNorte.add(this.lblFileName);
        pNorte.add(this.txtFileName);
        pNorte.add(this.lblFormat);
        pNorte.add(this.cbFormat);
        this.pBoundingBox = new Panel_BBox();
        JPanel pSur = new JPanel();
        this.pbDownload = new JButton("Download");
        this.pbDownload.addActionListener(this);
        this.pbCancel = new JButton("Cancel");
        this.pbCancel.addActionListener(this);
        pSur.setLayout(new FlowLayout());
        pSur.add(this.pbDownload);
        pSur.add(this.pbCancel);
        this.add((Component)pNorte, "North");
        this.add((Component)this.pBoundingBox, "Center");
        this.add((Component)pSur, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(f);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double margin = 0.0;
        if (e.getSource() == this.pbDownload) {
            UTMCoordinates utm_ne;
            UTMCoordinates utm_sw;
            String name = this.getNetworkName();
            String filename = this.getFilename();
            OSM_ExportFormat format = (OSM_ExportFormat)((Object)this.cbFormat.getSelectedItem());
            int coord = this.pBoundingBox.cbCoord.getSelectedIndex();
            if (coord == 0) {
                utm_sw = this.pBoundingBox.pUTM_SW.getValues();
                utm_ne = this.pBoundingBox.pUTM_NE.getValues();
                this.osm = new OpenStreetMap(filename, utm_sw, utm_ne, margin);
            } else {
                GeodeticCoordinates geo_sw = this.pBoundingBox.pLatLon_SW.getValues();
                GeodeticCoordinates geo_ne = this.pBoundingBox.pLatLon_NE.getValues();
                this.osm = new OpenStreetMap(filename, geo_sw, geo_ne);
            }
            Util.setCursorEsperas(this);
            String cmd = "";
            try {
                cmd = this.osm.download(filename, format, 0);
            }
            catch (OSM_Exception ex) {
                System.err.println(ex.toString());
            }
            NetworkBBox bbox = new NetworkBBox(name, null);
            String filename_bbox = bbox.getFilename();
            utm_sw = this.pBoundingBox.getBBox_utm_sw();
            utm_ne = this.pBoundingBox.getBBox_utm_ne();
            bbox.setBBox(utm_sw, utm_ne, margin);
            bbox.write_osm(filename_bbox);
            Util.setCursorNormal(this);
            if (cmd.isEmpty()) {
                JOptionPane.showMessageDialog(this, this.osm.getDownloadErrorMessage(), "Download a map from OpenStreetMap", 2);
            } else {
                this.canceled = false;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.pbCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getNetworkName() {
        String name = this.txtFileName.getText().trim();
        return name;
    }

    public String getFilename() {
        String filename = this.txtFileName.getText().trim() + "." + this.cbFormat.getSelectedItem().toString();
        return filename;
    }
}

