/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.Routes;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.frontend.MyFrame;
import gatcomsumo.frontend.Panel_Flow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import util.Colors;
import util.Util;

public class DlgFlow
extends JDialog
implements ActionListener,
WindowListener {
    private MyFrame f;
    private SUMO sumo;
    private Flow flow;
    private Panel_Flow pFlow;
    private JButton bOk;
    private JButton bCancel;
    private boolean canceled = false;

    public DlgFlow(MyFrame f, SUMO sumo, String title, Flow flow) {
        super(f, title, true);
        this.sumo = sumo;
        this.flow = flow;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.pFlow = new Panel_Flow(f, sumo);
        this.add((Component)this.pFlow, "Center");
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.setLayout(new FlowLayout());
        pButtons.add(this.bOk);
        pButtons.add(this.bCancel);
        this.object2components();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(f);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean routesModified() {
        return this.pFlow.routesMod;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOk) {
            this.components2object();
            this.canceled = false;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.canceled = true;
            this.setVisible(false);
        }
    }

    public void object2components() {
        double v = 0.0;
        this.pFlow.txtID.setText(this.flow.id);
        if (this.flow.type != null) {
            this.pFlow.cbType.setSelectedItem(this.flow.type);
        }
        if (this.flow.color != null) {
            this.pFlow.cbColor.setSelectedItem((Object)this.flow.color);
        }
        if (this.flow.route != null) {
            this.pFlow.cbRoute.setSelectedItem(this.flow.route);
            this.pFlow.txtRouteEdges.setText(this.flow.route.getEdges());
        } else {
            this.pFlow.cbRoute.setSelectedItem(Routes.routeNull);
        }
        this.pFlow.txtNumber.setText("" + this.flow.number);
        if (this.flow.vehsPerHour > 0.0) {
            v = this.flow.vehsPerHour;
            this.pFlow.cbFrecuency.setSelectedIndex(0);
        } else if (this.flow.period > 0.0) {
            v = this.flow.period;
            this.pFlow.cbFrecuency.setSelectedIndex(1);
        } else if (this.flow.probability > 0.0) {
            v = this.flow.probability;
            this.pFlow.cbFrecuency.setSelectedIndex(2);
        } else {
            this.pFlow.cbFrecuency.setSelectedIndex(0);
        }
        this.pFlow.txtFrecuency.setText("" + v);
        this.pFlow.pBegin.setSeconds(this.flow.begin);
        this.pFlow.pEnd.setSeconds(this.flow.end);
    }

    public void components2object() {
        this.flow.id = this.pFlow.txtID.getText();
        this.flow.type = (VehicleType)this.pFlow.cbType.getSelectedItem();
        this.flow.color = (Colors)((Object)this.pFlow.cbColor.getSelectedItem());
        Route route = (Route)this.pFlow.cbRoute.getSelectedItem();
        if (route == Routes.routeNull) {
            route = null;
        }
        if (route != this.flow.route) {
            this.flow.setRoute(route);
        }
        this.flow.number = Util.parseInt(this.pFlow.txtNumber.getText());
        double v = Util.parseDouble(this.pFlow.txtFrecuency.getText());
        int index = this.pFlow.cbFrecuency.getSelectedIndex();
        this.flow.probability = -1.0;
        this.flow.period = -1.0;
        this.flow.vehsPerHour = -1.0;
        if (v > 0.0) {
            switch (index) {
                case 0: {
                    this.flow.vehsPerHour = v;
                    break;
                }
                case 1: {
                    this.flow.period = v;
                    break;
                }
                case 2: {
                    this.flow.probability = v;
                    break;
                }
            }
        }
        this.flow.begin = this.pFlow.pBegin.getSeconds();
        this.flow.end = this.pFlow.pEnd.getSeconds();
    }
}

