/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.frontend;

import gatcomsumo.frontend.MyFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import util.Conv;
import util.Util;
import util.gui.MyTextAreaScrollable;
import wireless.PHY_FSPL;
import wireless.PHY_TwoRay;
import wireless.Units_Distance;
import wireless.Units_Frequency;

public class DlgCommRange
extends JDialog
implements ActionListener,
ItemListener {
    private MyFrame f;
    private JComboBox cbPropModel;
    private static final DecimalFormat f4dec = new DecimalFormat("#,##0.0000");
    private static final int INTERVALS = 50;
    private JLabel lblDistance;
    private JLabel lblDistCrossOver;
    private JLabel lblPtx;
    private JLabel lblPtxRange;
    private JLabel lblPrx;
    private JLabel lblPrxRange;
    private JTextField txtDistance;
    private JTextField txtDistCrossOver;
    private JTextField txtPtxFrom;
    private JTextField txtPtxTo;
    private JTextField txtPrxFrom;
    private JTextField txtPrxTo;
    private JComboBox cbDistanceUnits;
    private List lstSolutions;
    private MyTextAreaScrollable txtOmnetpp;
    private JButton pbCalculate;
    private JButton pbClose;
    private ArrayList<Double> listPtx;
    private ArrayList<Double> listPrx;
    private ArrayList<Double> listDst;
    private double gtx;
    private double grx;
    private double htx;
    private double hrx;
    private double distance;
    private double frequency;
    private Units_Distance d_units;
    private Units_Frequency f_units;
    private boolean tworay;

    public DlgCommRange(MyFrame f, JComboBox cbPropModel, double ptx, double prx, double gtx, double grx, double htx, double hrx, double distance, double frequency, Units_Distance d_units, Units_Frequency f_units) {
        super(f, "Communication Range Alternatives", true);
        this.f = f;
        this.cbPropModel = cbPropModel;
        this.gtx = gtx;
        this.grx = grx;
        this.htx = htx;
        this.hrx = hrx;
        this.distance = distance;
        this.frequency = frequency;
        this.d_units = d_units;
        this.f_units = f_units;
        this.tworay = cbPropModel.getSelectedIndex() == 1;
        double ptx_start = ptx * 0.9;
        double ptx_end = ptx * 1.1;
        double prx_start = prx * 1.1;
        double prx_end = prx * 0.9;
        this.lblDistance = new JLabel("Distance:");
        this.txtDistance = new JTextField(f4dec.format(distance), 8);
        this.cbDistanceUnits = new JComboBox();
        Units_Distance.fill(this.cbDistanceUnits);
        if (d_units == Units_Distance.METERS) {
            this.cbDistanceUnits.setSelectedIndex(0);
        } else {
            this.cbDistanceUnits.setSelectedIndex(1);
        }
        if (this.tworay) {
            this.lblDistCrossOver = new JLabel("Crossover distance:");
            this.txtDistCrossOver = new JTextField(f4dec.format(0L), 8);
            this.txtDistCrossOver.setEnabled(false);
            this.txtDistCrossOver.setToolTipText("The two-ray model does not give a good result for a short distance; when distance (d) is less than the crossover distance (dc), FSPL should be used.");
        }
        this.lblPtx = new JLabel("Tx transmission power (dBm):");
        this.txtPtxFrom = new JTextField(f4dec.format(ptx_start), 8);
        this.txtPtxFrom.setToolTipText("Transmit power of the sending node (from)");
        this.lblPtxRange = new JLabel(" to ");
        this.txtPtxTo = new JTextField(f4dec.format(ptx_end), 8);
        this.txtPtxTo.setToolTipText("Transmit power of the sending node (to)");
        this.lblPrx = new JLabel("Rx reception power threshold (dBm):");
        this.txtPrxFrom = new JTextField(f4dec.format(prx_start), 8);
        this.txtPrxFrom.setToolTipText("Received power threshold (receiver sensitivity) value of the receiving node in dBm (from)");
        this.lblPrxRange = new JLabel(" to ");
        this.txtPrxTo = new JTextField(f4dec.format(prx_end), 8);
        this.txtPrxTo.setToolTipText("Received power threshold (receiver sensitivity) value of the receiving node in dBm (to)");
        this.lstSolutions = new List(6);
        this.lstSolutions.addItemListener(this);
        this.txtOmnetpp = new MyTextAreaScrollable();
        this.txtOmnetpp.setEditable(false);
        this.pbCalculate = new JButton("Calculate");
        this.pbCalculate.addActionListener(this);
        this.pbClose = new JButton("Close");
        this.pbClose.addActionListener(this);
        JPanel pNorte = new JPanel();
        pNorte.setLayout(new GridLayout(3, 1));
        JPanel pNorte1 = new JPanel();
        pNorte1.setLayout(new FlowLayout(0));
        pNorte1.add(this.lblDistance);
        pNorte1.add(this.txtDistance);
        pNorte1.add(this.cbDistanceUnits);
        if (this.tworay) {
            pNorte1.add(this.lblDistCrossOver);
            pNorte1.add(this.txtDistCrossOver);
        }
        JPanel pNorte2 = new JPanel();
        pNorte2.setLayout(new FlowLayout(0));
        pNorte2.add(this.lblPtx);
        pNorte2.add(this.txtPtxFrom);
        pNorte2.add(this.lblPtxRange);
        pNorte2.add(this.txtPtxTo);
        JPanel pNorte3 = new JPanel();
        pNorte3.setLayout(new FlowLayout(0));
        pNorte3.add(this.lblPrx);
        pNorte3.add(this.txtPrxFrom);
        pNorte3.add(this.lblPrxRange);
        pNorte3.add(this.txtPrxTo);
        pNorte.add(pNorte1);
        pNorte.add(pNorte2);
        pNorte.add(pNorte3);
        JPanel pCentro = new JPanel();
        JPanel pCentro1 = new JPanel();
        TitledBorder border1 = new TitledBorder(" Solutions ");
        pCentro1.setBorder(border1);
        pCentro1.setLayout(new BorderLayout());
        pCentro1.add((Component)this.lstSolutions, "Center");
        JPanel pCentro2 = new JPanel();
        TitledBorder border2 = new TitledBorder(" File: omnetpp.ini (part) ");
        pCentro2.setBorder(border2);
        pCentro2.setLayout(new BorderLayout());
        pCentro2.add((Component)this.txtOmnetpp, "Center");
        pCentro.setLayout(new GridLayout(2, 1));
        pCentro.add(pCentro1);
        pCentro.add(pCentro2);
        JPanel pSur = new JPanel();
        pSur.setLayout(new FlowLayout());
        pSur.add(this.pbCalculate);
        pSur.add(this.pbClose);
        this.setLayout(new BorderLayout());
        this.add((Component)pNorte, "North");
        this.add((Component)pCentro, "Center");
        this.add((Component)pSur, "South");
        this.calculate(50);
        this.updateParameters();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgCommRange.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setSize(550, 370);
        this.setLocationRelativeTo(f);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pbCalculate) {
            this.calculate(50);
        } else if (e.getSource() == this.pbClose) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.lstSolutions) {
            this.updateParameters();
        }
    }

    private void calculate(int intervals) {
        int n;
        double dMax;
        double dMin;
        double ptx_start = Util.parseDouble(this.txtPtxFrom.getText());
        double ptx_end = Util.parseDouble(this.txtPtxTo.getText());
        double prx_start = Util.parseDouble(this.txtPrxFrom.getText());
        double prx_end = Util.parseDouble(this.txtPrxTo.getText());
        double ptx_incr = (ptx_end - ptx_start) / (double)intervals;
        double prx_incr = (prx_end - prx_start) / (double)intervals;
        double d = Util.parseDouble(this.txtDistance.getText());
        this.d_units = this.cbDistanceUnits.getSelectedIndex() == 0 ? Units_Distance.METERS : Units_Distance.KM;
        if (this.d_units == Units_Distance.METERS) {
            dMin = d - 1.0;
            dMax = d + 1.0;
        } else {
            dMin = d - 0.001;
            dMax = d + 0.001;
        }
        this.lstSolutions.removeAll();
        this.txtOmnetpp.setText("");
        this.listPtx = new ArrayList();
        this.listPrx = new ArrayList();
        this.listDst = new ArrayList();
        for (double ptx = ptx_start; ptx <= ptx_end; ptx += ptx_incr) {
            for (double prx = prx_start; prx <= prx_end; prx += prx_incr) {
                d = !this.tworay ? PHY_FSPL.communicationRange_dB1(ptx, prx, this.gtx, this.grx, this.frequency, this.d_units, this.f_units) : PHY_TwoRay.communicationRange_dB1(ptx, prx, this.gtx, this.grx, this.htx, this.hrx, this.d_units);
                if (!(d > dMin) || !(d < dMax)) continue;
                this.listPtx.add(ptx);
                this.listPrx.add(prx);
                this.listDst.add(d);
                if (!(prx_incr < 1.0E-9)) continue;
            }
            if (!(ptx_incr < 1.0E-9)) continue;
        }
        if ((n = this.listPtx.size()) == 0) {
            JOptionPane.showMessageDialog(this, "Con los par\u00e1metros actuales no se han encontrado posibilidades para conseguir la distancia requerida.", "No hay soluci\u00f3n", 2);
            return;
        }
        for (int i = 0; i < n; ++i) {
            double dBm = this.listPtx.get(i);
            double mW = Conv.dBm_to_watts(dBm) * 1000.0;
            String item = "Ptx=" + f4dec.format(dBm) + " dBm (" + f4dec.format(mW) + " mW); Prx=" + f4dec.format(this.listPrx.get(i)) + " dBm -> distance=" + f4dec.format(this.listDst.get(i)) + " " + this.d_units.getUnits();
            this.lstSolutions.add(item);
        }
        if (this.lstSolutions.getItemCount() > 0) {
            this.lstSolutions.select(0);
            this.updateParameters();
        }
    }

    private void updateParameters() {
        String propModel;
        if (this.tworay) {
            double dc = PHY_TwoRay.minimumDistance(this.htx, this.hrx, this.frequency, this.d_units, this.f_units);
            this.txtDistCrossOver.setText(f4dec.format(dc));
            propModel = "TwoRayInterferenceModel";
        } else {
            propModel = "SimplePathlossModel";
        }
        if (this.lstSolutions.getItemCount() == 0) {
            this.txtOmnetpp.setText("");
            return;
        }
        int index = this.lstSolutions.getSelectedIndex();
        double Ptx = this.listPtx.get(index);
        double mW = Conv.dBm_to_watts(Ptx) * 1000.0;
        double Prx = this.listPrx.get(index);
        double dst = this.listDst.get(index);
        double f_hz = this.frequency / this.f_units.getConv2Hz();
        String omnetpp = "# Communication range: " + Util.doubleWithDotPoint(f4dec.format(dst)) + " " + this.d_units.getUnits() + "\n";
        omnetpp = omnetpp + "*.**.nic.mac1609_4.txPower = " + Util.doubleWithDotPoint(f4dec.format(mW)) + " mW   # " + Util.doubleWithDotPoint(f4dec.format(Ptx)) + " dBm\n";
        omnetpp = omnetpp + "*.**.nic.phy80211p.sensitivity = " + Util.doubleWithDotPoint(f4dec.format(Prx)) + " dBm\n\n";
        omnetpp = omnetpp + "# Interference range: " + Util.doubleWithDotPoint(f4dec.format(dst)) + " " + this.d_units.getUnits() + "\n";
        omnetpp = omnetpp + "*.connectionManager.pMax = " + Util.doubleWithDotPoint(f4dec.format(mW)) + " mW   # " + Util.doubleWithDotPoint(f4dec.format(Ptx)) + " dBm\n";
        omnetpp = omnetpp + "*.connectionManager.sat = " + Util.doubleWithDotPoint(f4dec.format(Prx)) + " dBm\n";
        omnetpp = omnetpp + "*.connectionManager.alpha = 2.0\n";
        omnetpp = omnetpp + "*.connectionManager.carrierFrequency = " + this.frequency + " " + this.f_units.getUnits() + "\n";
        omnetpp = omnetpp + "*.connectionManager.drawMaxIntfDist = false\n\n";
        omnetpp = omnetpp + "# The used propagation model is set in the config.xml file\n";
        omnetpp = omnetpp + "# <AnalogueModel type=\"" + propModel + "\">\n";
        omnetpp = omnetpp + "#    <parameter name=\"carrierFrequency\" type=\"double\" value=\"" + f_hz + "\"/>\n";
        this.txtOmnetpp.setText(omnetpp);
    }
}

