/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleComparator;
import java.awt.Choice;
import java.awt.List;
import java.util.ArrayList;
import java.util.Collections;
import util.Util;
import util.gui.MyTable;

public class Vehicles {
    public ArrayList<Vehicle> list = new ArrayList();
    private VehicleComparator comparator = new VehicleComparator();

    public void init() {
        this.list.clear();
    }

    public Vehicle search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Vehicle vehicle : this.list) {
            if (!vehicle.id.equalsIgnoreCase(id)) continue;
            return vehicle;
        }
        return null;
    }

    public String getLastPrefix() {
        if (this.list.size() == 0) {
            return "vehicle";
        }
        Vehicle vehicle = this.list.get(this.list.size() - 1);
        String[] id = vehicle.id.split("-");
        if (id.length == 2) {
            return id[0];
        }
        return "vehicle";
    }

    public int getLastIndex(String prefix) {
        int maxIndex = -1;
        for (Vehicle vehicle : this.list) {
            int index;
            String[] id;
            if (vehicle.id.indexOf(45) < 0 || (id = vehicle.id.split("-")).length != 2 || !id[0].equalsIgnoreCase(prefix) || (index = Util.parseInt(id[1])) <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex;
    }

    public double getMaxDepartTime() {
        double lastDepart = -1.0;
        for (Vehicle vehicle : this.list) {
            if (!(vehicle.depart > lastDepart)) continue;
            lastDepart = vehicle.depart;
        }
        return lastDepart;
    }

    public int fill(Choice comp) {
        comp.removeAll();
        for (Vehicle vehicle : this.list) {
            comp.add(vehicle.id);
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Vehicle vehicle : this.list) {
            comp.add(vehicle.id);
        }
        return this.list.size();
    }

    public int fill(MyTable table) {
        table.removeAllRows();
        int row = 0;
        for (Vehicle vehicle : this.list) {
            Object[] data = vehicle.buildRowTable(row);
            table.appendRow(data, true);
            ++row;
        }
        if (table.getNumRows() > 0) {
            table.selectRow(0);
        }
        return table.getNumRows();
    }

    public String toString() {
        String s = "" + this.list.size() + " vehicles";
        return s;
    }

    public void sortByStartTime() {
        Collections.sort(this.list, this.comparator);
    }

    public VehicleComparator getComparator() {
        return this.comparator;
    }
}

