/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.VehicleClasses;
import gatcomsumo.backend.VehicleType;
import java.awt.Choice;
import java.awt.List;
import java.util.ArrayList;
import javax.swing.JComboBox;
import util.gui.MyTable;

public class VehicleTypes {
    public ArrayList<VehicleType> list = new ArrayList();

    public VehicleTypes() {
        this.init();
    }

    public void init() {
        this.list.clear();
        for (VehicleClasses vc : VehicleClasses.values()) {
            VehicleType vt = new VehicleType(vc.name(), vc);
            this.list.add(vt);
        }
    }

    public VehicleType search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (VehicleType vehicletype : this.list) {
            if (!vehicletype.id.equalsIgnoreCase(id)) continue;
            return vehicletype;
        }
        return null;
    }

    public int fill(Choice comp) {
        comp.removeAll();
        for (VehicleType vehicletype : this.list) {
            comp.add(vehicletype.toString());
        }
        return this.list.size();
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (VehicleType vehicletype : this.list) {
            comp.addItem(vehicletype.toString());
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (VehicleType vehicletype : this.list) {
            comp.add(vehicletype.toString());
        }
        return this.list.size();
    }

    public int fill(MyTable table) {
        table.removeAllRows();
        int row = 0;
        for (VehicleType vehicletype : this.list) {
            Object[] data = vehicletype.buildRowTable(row);
            table.appendRow(data, true);
            ++row;
        }
        if (table.getNumRows() > 0) {
            table.selectRow(0);
        }
        return table.getNumRows();
    }

    public String toString() {
        String s = "" + this.list.size() + " vehicle types";
        return s;
    }
}

