/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.CarFollowingModels;
import gatcomsumo.backend.GuiShapes;
import gatcomsumo.backend.LaneChangingModels;
import gatcomsumo.backend.LateralAlignment;
import gatcomsumo.backend.VehicleClasses;
import util.Colors;

public class VehicleType {
    public String id;
    public VehicleClasses vClass = VehicleClasses.passenger;
    public Colors color;
    public GuiShapes guishape = GuiShapes.PASSENGER;
    public double length = 5.0;
    public double width = 2.0;
    public String guiimgFile = null;
    public double accel = 2.6;
    public double decel = 4.5;
    public double maxSpeed = 70.0;
    public double speedFactor = 1.0;
    public double speedDev = 0.0;
    public double sigma = 0.5;
    public double tau = 1.0;
    public double impatience = 0.0;
    public double minGap = 2.5;
    public LaneChangingModels laneChangeModel = null;
    public CarFollowingModels carFollowModel = null;
    public int personCapacity = 4;
    public double boardingDuration = 0.5;
    public int containerCapacity = 0;
    public double loadingDuration = 90.0;
    public LateralAlignment latAlignment;
    public double minGapLat = 0.12;
    public double maxSpeedLat = 1.0;
    public static final String[] HEADERS = new String[]{"#", "ID", "Color", "Shape", "Length", "Width", "Max. speed"};
    public static final int[] NONEDITABLECOLS = new int[]{0, 1, 2, 3, 4, 5, 6};

    public VehicleType() {
    }

    public VehicleType(String id) {
        this.id = id;
    }

    public VehicleType(String id, VehicleClasses vClass) {
        this.id = id;
        this.vClass = vClass;
    }

    public void setLaneChangeModel(LaneChangingModels model) {
        this.laneChangeModel = model;
    }

    public void setCarFollowingModel(CarFollowingModels model) {
        this.carFollowModel = model;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<vType id=\"" + this.id + "\" length=\"" + this.length + "\" width=\"" + this.width + "\" maxSpeed=\"" + this.maxSpeed + "\"");
        sb.append(" accel=\"" + this.accel + "\" decel=\"" + this.decel + "\" sigma=\"" + this.sigma + "\"/>\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = this.id;
        return s;
    }

    public Object[] buildRowTable(int row) {
        int ncols = HEADERS.length;
        Object[] data = new Object[ncols];
        data[0] = row + 1 + "";
        data[1] = this.id;
        data[2] = this.color;
        data[3] = this.guishape.toString();
        data[4] = this.length;
        data[5] = this.width;
        data[6] = this.maxSpeed;
        return data;
    }
}

