/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Route;
import gatcomsumo.backend.VehicleType;
import util.Colors;

public class Vehicle {
    public String id;
    public VehicleType type;
    public Colors color;
    public Route route;
    public double depart;
    public int departlane;
    public double departpos;
    public double departspeed;
    public int arrivallane;
    public double arrivalpos;
    public double arrivalspeed;
    public static final String[] HEADERS = new String[]{"#", "ID", "Type", "Color", "Depart (s)", "Route"};
    public static final int[] NONEDITABLECOLS = new int[]{0, 1, 2, 3, 4, 5};

    public Vehicle() {
    }

    public Vehicle(String id, VehicleType type) {
        this(id, type, Colors.YELLOW);
    }

    public Vehicle(String id, VehicleType type, Colors color) {
        this.id = id;
        this.type = type;
        this.color = color;
    }

    public void setDepart(double depart) {
        this.depart = depart;
    }

    public void setColor(Colors color) {
        this.color = color;
    }

    public void setRoute(Route route) {
        if (this.route != null) {
            this.route.removeVehicle(this);
        }
        this.route = route;
        if (this.route != null) {
            this.route.addVehicle(this);
        }
    }

    public String toString() {
        String s = this.id + " (type=" + this.type + ";depart=" + this.depart + ")";
        return s;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<vehicle id=\"" + this.id + "\" type=\"" + this.type + "\" color=\"" + (Object)((Object)this.color) + "\" ");
        sb.append("depart=\"" + this.depart + "\" ");
        if (this.route != null) {
            sb.append("route=\"" + this.route.id + "\"");
        }
        sb.append("/>\n");
        String s = new String(sb);
        return s;
    }

    public Object[] buildRowTable(int row) {
        int ncols = HEADERS.length;
        Object[] data = new Object[ncols];
        data[0] = row + 1 + "";
        data[1] = this.id;
        data[2] = this.type;
        data[3] = this.color;
        data[4] = this.depart;
        data[5] = this.route;
        return data;
    }
}

