/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Trip;
import gatcomsumo.backend.TripComparator;
import java.awt.List;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import util.Util;

public class Trips {
    private SUMO sumo;
    public ArrayList<Trip> list;
    private TripComparator comparator;

    public Trips(SUMO sumo) {
        this.sumo = sumo;
        this.list = new ArrayList();
        this.comparator = new TripComparator();
    }

    public void init() {
        this.list.clear();
    }

    public Trip search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Trip trip : this.list) {
            if (!trip.id.equalsIgnoreCase(id)) continue;
            return trip;
        }
        return null;
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (Trip trip : this.list) {
            comp.addItem(trip);
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Trip trip : this.list) {
            comp.add(trip.toString());
        }
        return this.list.size();
    }

    public String toString() {
        String s = "" + this.list.size() + " trips";
        return s;
    }

    public void sortByStartTime() {
        Collections.sort(this.list, this.comparator);
    }

    public TripComparator getComparator() {
        return this.comparator;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("<trips> <!-- The opening tag -->\n");
        for (Trip trip : this.list) {
            sb.append("   " + trip.toXML());
        }
        sb.append("</trips> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }

    public boolean saveXML(String filename_xml) {
        boolean ok = true;
        String s = this.toXML();
        ok = Util.writeTextFile(filename_xml, s);
        return ok;
    }
}

