/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import java.util.ArrayList;
import util.Colors;

public class Trip {
    public String id;
    public double depart;
    public Edge fromEdge;
    public Edge toEdge;
    public ArrayList<Edge> via;
    public Colors color;

    public Trip(String id, Edge fromEdge, Edge toEdge, double depart, Colors color) {
        this.id = id;
        this.fromEdge = fromEdge;
        this.toEdge = toEdge;
        this.via = new ArrayList();
        this.depart = depart;
        this.color = color;
    }

    public void setDepart(double depart) {
        this.depart = depart;
    }

    public void setColor(Colors color) {
        this.color = color;
    }

    public void addIntermediateEdge(Edge edge) {
        this.via.add(edge);
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<trip id=\"" + this.id + "\" from=\"" + this.fromEdge.id + "\" to=\"" + this.toEdge.id + "\"");
        sb.append(" depart=\"" + this.depart + "\" color=\"" + (Object)((Object)this.color) + "\"");
        if (!this.via.isEmpty()) {
            boolean first = true;
            sb.append(" via=\"");
            for (Edge edge : this.via) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                sb.append(edge.id);
            }
            sb.append("\"");
        }
        sb.append("/>\n");
        String s = new String(sb);
        return s;
    }
}

