/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Flow;
import gatcomsumo.backend.Flows;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.Routes;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Trips;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleType;
import gatcomsumo.backend.VehicleTypes;
import gatcomsumo.backend.Vehicles;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.Colors;
import util.MyXML;
import util.Util;

public class TrafficDemand {
    SUMO sumo;
    public Vehicles vehicles;
    public VehicleTypes vehicletypes;
    public Flows flows;
    public Routes routes;
    public Trips trips;
    private int totalUnknownEdges;
    private int ignoredRoutes;
    private String loadErrorMessage;
    private boolean changed;

    public TrafficDemand(SUMO sumo) {
        this.sumo = sumo;
        this.vehicles = new Vehicles();
        this.vehicletypes = new VehicleTypes();
        this.flows = new Flows();
        this.routes = new Routes(sumo);
        this.trips = new Trips(sumo);
        this.changed = false;
    }

    public void init() {
        this.vehicles.init();
        this.vehicletypes.init();
        this.flows.init();
        this.routes.init();
        this.trips.init();
        this.changed = false;
    }

    public String getLoadErrorMessage() {
        return this.loadErrorMessage;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean loadXML(String filename_xml) {
        int nRoutes;
        NodeList listXMLRoute;
        String type;
        int unknownEdges;
        String edges;
        String color;
        Element elementXMLRoute;
        Element elementXML;
        int i;
        boolean ok = true;
        Route route = null;
        this.totalUnknownEdges = 0;
        this.ignoredRoutes = 0;
        this.loadErrorMessage = "";
        MyXML xml = new MyXML();
        if (!xml.open(filename_xml)) {
            this.loadErrorMessage = xml.getErrorMessage();
            return false;
        }
        String s = xml.getRoot();
        if (!s.equalsIgnoreCase("routes")) {
            this.loadErrorMessage = "Root node is '" + s + "' but it should be 'routes'";
            return false;
        }
        NodeList listXML = xml.getElements("vType");
        int n = listXML.getLength();
        this.vehicletypes.init();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(listXML, i);
            s = MyXML.getParam(elementXML, "id", "");
            VehicleType vtype = this.vehicletypes.search(s);
            if (vtype == null) {
                vtype = new VehicleType();
                this.vehicletypes.list.add(vtype);
            }
            vtype.id = s;
            vtype.length = MyXML.getParam(elementXML, "length", vtype.length);
            vtype.maxSpeed = MyXML.getParam(elementXML, "maxSpeed", vtype.maxSpeed);
            vtype.accel = MyXML.getParam(elementXML, "accel", vtype.accel);
            vtype.decel = MyXML.getParam(elementXML, "decel", vtype.decel);
            vtype.sigma = MyXML.getParam(elementXML, "sigma", vtype.sigma);
        }
        listXML = xml.getElements("route");
        n = listXML.getLength();
        this.routes.list.clear();
        for (i = 0; i < n; ++i) {
            elementXMLRoute = MyXML.getElement(listXML, i);
            s = MyXML.getParam(elementXMLRoute, "id", "");
            if (s == null || s.isEmpty() || this.routes.search(s) != null) continue;
            route = new Route();
            route.id = s;
            color = MyXML.getParam(elementXMLRoute, "color", "orange");
            route.color = Colors.search(color);
            edges = MyXML.getParam(elementXMLRoute, "edges", "");
            unknownEdges = this.loadXML_edges(edges, route.edges);
            if (unknownEdges == 0) {
                this.routes.list.add(route);
                continue;
            }
            this.totalUnknownEdges += unknownEdges;
            ++this.ignoredRoutes;
        }
        listXML = xml.getElements("vehicle");
        n = listXML.getLength();
        this.vehicles.list.clear();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(listXML, i);
            Vehicle vehicle = new Vehicle();
            this.vehicles.list.add(vehicle);
            vehicle.id = MyXML.getParam(elementXML, "id", vehicle.id);
            type = MyXML.getParam(elementXML, "type", "");
            vehicle.type = this.vehicletypes.search(type);
            color = MyXML.getParam(elementXML, "color", "");
            vehicle.color = Colors.search(color);
            vehicle.depart = MyXML.getParam(elementXML, "depart", vehicle.depart);
            route = null;
            s = MyXML.getParam(elementXML, "route", "");
            if (s != null && !s.isEmpty()) {
                route = this.routes.search(s);
                vehicle.setRoute(route);
                continue;
            }
            listXMLRoute = xml.getSubElements(elementXML, "route");
            nRoutes = listXMLRoute.getLength();
            if (nRoutes <= 0) continue;
            elementXMLRoute = MyXML.getElement(listXMLRoute, 0);
            s = MyXML.getParam(elementXMLRoute, "id", vehicle.id);
            route = this.routes.search(s);
            if (route == null) {
                route = new Route();
                route.id = s;
                color = MyXML.getParam(elementXML, "color", "orange");
                route.color = Colors.search(color);
                edges = MyXML.getParam(elementXMLRoute, "edges", "");
                unknownEdges = this.loadXML_edges(edges, route.edges);
                if (unknownEdges == 0) {
                    this.routes.list.add(route);
                } else {
                    this.totalUnknownEdges += unknownEdges;
                    ++this.ignoredRoutes;
                }
            }
            vehicle.setRoute(route);
        }
        listXML = xml.getElements("flow");
        n = listXML.getLength();
        this.flows.list.clear();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(listXML, i);
            Flow flow = new Flow();
            this.flows.list.add(flow);
            flow.id = MyXML.getParam(elementXML, "id", flow.id);
            type = MyXML.getParam(elementXML, "type", "");
            flow.type = this.vehicletypes.search(type);
            color = MyXML.getParam(elementXML, "color", "");
            flow.color = Colors.search(color);
            flow.number = MyXML.getParam(elementXML, "number", flow.number);
            flow.begin = MyXML.getParam(elementXML, "begin", flow.begin);
            flow.end = MyXML.getParam(elementXML, "end", flow.end);
            flow.vehsPerHour = MyXML.getParam(elementXML, "vehsPerHour", flow.vehsPerHour);
            flow.period = MyXML.getParam(elementXML, "period", flow.period);
            flow.probability = MyXML.getParam(elementXML, "probability", flow.probability);
            route = null;
            s = MyXML.getParam(elementXML, "route", "");
            if (s != null && !s.isEmpty()) {
                route = this.routes.search(s);
                flow.setRoute(route);
                continue;
            }
            listXMLRoute = xml.getSubElements(elementXML, "route");
            nRoutes = listXMLRoute.getLength();
            if (nRoutes <= 0) continue;
            elementXMLRoute = MyXML.getElement(listXMLRoute, 0);
            s = MyXML.getParam(elementXMLRoute, "id", "route-flow-" + flow.id);
            route = this.routes.search(s);
            if (route == null) {
                route = new Route();
                route.id = s;
                color = MyXML.getParam(elementXMLRoute, "color", "orange");
                route.color = Colors.search(color);
                edges = MyXML.getParam(elementXMLRoute, "edges", "");
                this.loadXML_edges(edges, route.edges);
                unknownEdges = this.loadXML_edges(edges, route.edges);
                if (unknownEdges == 0) {
                    this.routes.list.add(route);
                } else {
                    this.totalUnknownEdges += unknownEdges;
                    ++this.ignoredRoutes;
                }
            }
            flow.setRoute(route);
        }
        if (this.ignoredRoutes > 0 || this.totalUnknownEdges > 0) {
            this.loadErrorMessage = "There are " + this.totalUnknownEdges + " unknown edges; " + this.ignoredRoutes + " routes have been ignored.\nIf you have already load a network file, check traffic demand file and network file.";
        }
        this.changed = false;
        return ok;
    }

    private int loadXML_edges(String edges_text, ArrayList edges) {
        int unknownEdges = 0;
        edges.clear();
        if (edges_text == null || edges_text.isEmpty()) {
            return -1;
        }
        String[] ids = edges_text.split("\\s");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].trim().isEmpty()) continue;
            Edge edge = this.sumo.network.edges.searchBinary(ids[i]);
            if (edge != null) {
                edges.add(edge);
                continue;
            }
            System.err.println("Unknown edge: " + ids[i]);
            ++unknownEdges;
        }
        return unknownEdges;
    }

    public boolean saveXML(String filename_xml) {
        boolean ok = true;
        String s = this.toXML();
        ok = Util.writeTextFile(filename_xml, s);
        return ok;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        ArrayList<VehicleType> vTypes = new ArrayList<VehicleType>();
        for (Route route : this.routes.list) {
            VehicleType vtype;
            for (Vehicle vehicle : route.vehicles) {
                vtype = vehicle.type;
                if (vTypes.contains(vtype)) continue;
                vTypes.add(vtype);
            }
            for (Flow flow : route.flows) {
                vtype = flow.type;
                if (vTypes.contains(vtype)) continue;
                vTypes.add(vtype);
            }
        }
        sb.append("<?xml version=\"1.0\"?>\n\n");
        sb.append("<routes> <!-- The opening tag -->\n\n");
        sb.append("   <!-- Vehicle types -->\n");
        for (VehicleType vtype : vTypes) {
            sb.append("   " + vtype.toXML());
        }
        sb.append("\n");
        sb.append("   <!-- Routes + associated vehicles & flows -->\n");
        for (Route route : this.routes.list) {
            sb.append("   " + route.toXML() + "\n");
        }
        sb.append("</routes> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }
}

