/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Network;
import gatcomsumo.backend.NetworkType;
import gatcomsumo.backend.TrafficDemand;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.MyXML;
import util.Util;

public class SUMO {
    public static final String DEFAULT_NETWORK = "elche";
    public static final String OSM_SUFFIX = ".osm.xml";
    public static final String NETWORK_SUFFIX = ".net.xml";
    public static final String OBSTACLES_SUFFIX = ".poly.xml";
    public static final String ROUTES_SUFFIX = ".rou.xml";
    public static final String TRIPS_SUFFIX = ".trip.xml";
    String prjname;
    public Network network;
    public TrafficDemand trafficDemand;

    public SUMO(String prjname) {
        this(prjname, NetworkType.OPENSTREETMAP);
    }

    public SUMO(String prjname, NetworkType type) {
        this.prjname = prjname;
        this.network = new Network(prjname, type);
        this.trafficDemand = new TrafficDemand(this);
    }

    public String getProjectName() {
        return this.prjname;
    }

    public Network getNetwork() {
        return this.network;
    }

    public TrafficDemand getTrafficDemand() {
        return this.trafficDemand;
    }

    public void init(String prjname, NetworkType type) {
        this.prjname = prjname;
        this.network.init(prjname, type);
        this.trafficDemand.init();
    }

    public String generateConfigFile() {
        String filename = this.prjname + ".sumo.cfg";
        StringBuilder sb = new StringBuilder("<configuration>\n");
        sb.append("    <input>\n");
        sb.append("        <net-file value=\"" + this.prjname + ".net.xml\"/>\n");
        sb.append("        <route-files value=\"" + this.prjname + ".rou.xml\"/>\n");
        sb.append("        <additional-files value=\"" + this.prjname + ".poly.xml\"/>\n");
        sb.append("    </input>\n");
        sb.append("</configuration>\n");
        String text = new String(sb);
        Util.writeTextFile(filename, text);
        return text;
    }

    public static File getPathHome() {
        File path;
        String pathname;
        if (Util.isMac()) {
            pathname = "/opt/local/share/sumo";
        } else if (Util.isUnix()) {
            pathname = "/usr/local/sumo-0.25.0";
        } else if (Util.isWindows()) {
            pathname = "E:\\tutores\\00\\sumo-0.25.0";
            path = new File(pathname);
            if (!path.exists() && !(path = new File(pathname = System.getenv("ProgramFiles") + "\\sumo-0.25.0\\bin")).exists()) {
                pathname = System.getenv("%programfiles% (x86)") + "\\sumo-0.25.0\\bin";
                if (!path.exists()) {
                    return null;
                }
            }
        } else {
            return null;
        }
        path = new File(pathname);
        return path;
    }

    public static File getPathBin() {
        String pathname = SUMO.getPathHome() + File.separator + "bin";
        File path = new File(pathname);
        return path;
    }

    public static File getFile_osmNetconvert() {
        String pathname = SUMO.getPathHome() + File.separator + "data" + File.separator + "typemap" + File.separator + "osmNetconvert.typ.xml";
        File path = new File(pathname);
        return path;
    }

    public static File getFile_osmNetconvert(String sumo_home) {
        String pathname = sumo_home + File.separator + "data" + File.separator + "typemap" + File.separator + "osmNetconvert.typ.xml";
        File path = new File(pathname);
        return path;
    }

    public ArrayList<String> getPolyTypes() {
        MyXML xml = new MyXML();
        String filename_xml = this.prjname + OBSTACLES_SUFFIX;
        if (!xml.open(filename_xml)) {
            return null;
        }
        String s = xml.getRoot();
        if (!s.equalsIgnoreCase("shapes") && !s.equalsIgnoreCase("additional")) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        NodeList listXML = xml.getElements("poly");
        int n = listXML.getLength();
        for (int i = 0; i < n; ++i) {
            Element elementXML = MyXML.getElement(listXML, i);
            s = MyXML.getParam(elementXML, "type", "");
            if (types.contains(s)) continue;
            types.add(s);
        }
        return types;
    }
}

