/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.FlowComparator;
import gatcomsumo.backend.Route;
import gatcomsumo.backend.SUMO;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleComparator;
import java.awt.List;
import java.util.ArrayList;
import javax.swing.JComboBox;
import util.Util;
import util.gui.MyTable;

public class Routes {
    private SUMO sumo;
    public ArrayList<Route> list;
    public static final Route routeNull = new Route("<Select route>");

    public Routes(SUMO sumo) {
        this.sumo = sumo;
        this.list = new ArrayList();
    }

    public void init() {
        this.list.clear();
    }

    public Route search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Route route : this.list) {
            if (!route.id.equalsIgnoreCase(id)) continue;
            return route;
        }
        return null;
    }

    public String getLastPrefix() {
        if (this.list.size() == 0) {
            return "vehicle";
        }
        Route route = this.list.get(this.list.size() - 1);
        String[] id = route.id.split("-");
        if (id.length == 2) {
            return id[0];
        }
        return "route";
    }

    public int getLastIndex(String prefix) {
        int maxIndex = -1;
        for (Route route : this.list) {
            int index;
            String[] id;
            if (route.id.indexOf(45) < 0 || (id = route.id.split("-")).length != 2 || !id[0].equalsIgnoreCase(prefix) || (index = Util.parseInt(id[1])) <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex;
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (Route route : this.list) {
            comp.addItem(route);
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Route route : this.list) {
            comp.add(route.toString());
        }
        return this.list.size();
    }

    public int fill(MyTable table) {
        table.removeAllRows();
        int row = 0;
        for (Route route : this.list) {
            Object[] data = route.buildRowTable(row);
            table.appendRow(data, true);
            ++row;
        }
        if (table.getNumRows() > 0) {
            table.selectRow(0);
        }
        return table.getNumRows();
    }

    public String toString() {
        String s = "" + this.list.size() + " routes";
        return s;
    }

    public void sortByDepartTime() {
        VehicleComparator vComparator = this.sumo.trafficDemand.vehicles.getComparator();
        FlowComparator fComparator = this.sumo.trafficDemand.flows.getComparator();
        for (Route route : this.list) {
            route.sortVehiclesFlowsByStartTime(vComparator, fComparator);
        }
    }

    public void removeVehicle(Vehicle vehicle) {
        for (Route route : this.sumo.trafficDemand.routes.list) {
            route.removeVehicle(vehicle);
        }
    }
}

