/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.Flow;
import gatcomsumo.backend.FlowComparator;
import gatcomsumo.backend.Routes;
import gatcomsumo.backend.Vehicle;
import gatcomsumo.backend.VehicleComparator;
import gatcomsumo.backend.VehicleType;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import util.Colors;
import util.gui.MyTable;

public class Route {
    public String id;
    public Colors color;
    public ArrayList<Edge> edges;
    public ArrayList<Vehicle> vehicles;
    public ArrayList<Flow> flows;
    public static final String[] HEADERS = new String[]{"#", "ID", "Color", "Distance (m)", "Vehicles", "Flows"};
    public static final int[] NONEDITABLECOLS = new int[]{0, 1, 2, 3, 4, 5};

    public Route() {
        this("", Colors.ORANGE);
    }

    public Route(String id) {
        this(id, Colors.ORANGE);
    }

    public Route(String id, Colors color) {
        this.id = id;
        this.color = color;
        this.edges = new ArrayList();
        this.flows = new ArrayList();
        this.vehicles = new ArrayList();
    }

    public void addVehicle(Vehicle vehicle) {
        if (!this.vehicles.contains(vehicle)) {
            this.vehicles.add(vehicle);
            vehicle.route = this;
        }
    }

    public void removeVehicle(Vehicle vehicle) {
        if (this.vehicles.contains(vehicle)) {
            this.vehicles.remove(vehicle);
            vehicle.route = null;
        }
    }

    public void addFlow(Flow flow) {
        if (!this.flows.contains(flow)) {
            this.flows.add(flow);
            flow.route = this;
        }
    }

    public void removeFlow(Flow flow) {
        if (this.flows.contains(flow)) {
            this.flows.remove(flow);
            flow.route = null;
        }
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public String getEdges() {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = this.edges.get(i);
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(edge.getID());
        }
        String s = new String(sb);
        return s;
    }

    public boolean contains(Edge edge) {
        boolean ok = this.edges.contains(edge);
        return ok;
    }

    public Edge isUnconnected() {
        if (this.edges.size() < 2) {
            return null;
        }
        for (int i = 0; i < this.edges.size() - 1; ++i) {
            Edge edge2;
            Edge edge1 = this.edges.get(i);
            if (edge1.isAdjacent(edge2 = this.edges.get(i + 1))) continue;
            return edge1;
        }
        return null;
    }

    public double length() {
        double length = 0.0;
        for (Edge edge : this.edges) {
            length += edge.length();
        }
        return length;
    }

    public boolean insideBBOX(Rectangle2D.Double bbox) {
        for (Edge edge : this.edges) {
            if (edge.insideBBOX(bbox)) continue;
            return false;
        }
        return true;
    }

    public void getRectangle(Rectangle2D.Double r) {
        for (Edge edge : this.edges) {
            edge.getRectangle(r);
        }
    }

    public boolean allowVehicleType(VehicleType vehicleType) {
        for (Edge edge : this.edges) {
            if (edge.allowVehicleType(vehicleType.id)) continue;
            return false;
        }
        return true;
    }

    public String generateRoutesByTurnProbabilities(String prjname) {
        String cmd = "jtrrouter ";
        cmd = cmd + " --flows=   --turns=  --net=" + prjname + " -b XX -e XX";
        cmd = cmd + " --output-file=" + prjname + ".rou.xml";
        return cmd;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<route id=\"" + this.id + "\" color=\"" + (Object)((Object)this.color) + "\" ");
        sb.append("edges=\"" + this.getEdges() + "\"/>\n");
        for (Vehicle vehicle : this.vehicles) {
            sb.append("   " + vehicle.toXML());
        }
        for (Flow flow : this.flows) {
            sb.append("   " + flow.toXML());
        }
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = this.id;
        if (this != Routes.routeNull) {
            s = s + " (" + String.format("%.2f", this.length()) + " m.)";
        }
        return s;
    }

    public void sortVehiclesFlowsByStartTime(VehicleComparator vComparator, FlowComparator fComparator) {
        Collections.sort(this.vehicles, vComparator);
        Collections.sort(this.flows, fComparator);
    }

    public Object[] buildRowTable(int row) {
        int ncols = HEADERS.length;
        Object[] data = new Object[ncols];
        data[0] = row + 1 + "";
        data[1] = this.id;
        data[2] = this.color;
        data[3] = String.format("%.2f", this.length());
        data[4] = this.vehicles.size();
        data[5] = this.flows.size();
        return data;
    }

    public int fill(MyTable table) {
        Edge lastEdge = null;
        table.removeAllRows();
        int row = 0;
        for (Edge edge : this.edges) {
            Object[] data = edge.buildRowTable(row, lastEdge);
            table.appendRow(data, true);
            ++row;
            lastEdge = edge;
        }
        if (table.getNumRows() > 0) {
            table.selectRow(0);
        }
        return table.getNumRows();
    }
}

