/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Node;
import java.awt.List;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;

public class Nodes {
    public ArrayList<Node> list;
    private Node nodeSearchBinary;
    Comparator<Node> comparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return o1.id.compareTo(o2.id);
        }
    };

    public Nodes() {
        this.list = new ArrayList();
        this.nodeSearchBinary = new Node();
    }

    public void clear() {
        this.list.clear();
    }

    public Node search(String id) {
        if (id == null) {
            return null;
        }
        String idt = id.trim();
        if (idt.isEmpty()) {
            return null;
        }
        for (Node node : this.list) {
            if (!node.id.equalsIgnoreCase(idt)) continue;
            return node;
        }
        return null;
    }

    public boolean insertSorted(Node newNode) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.list.get(i);
            int comp = node.id.compareTo(newNode.id);
            if (comp < 0) continue;
            if (comp == 0) {
                return false;
            }
            this.list.add(i, newNode);
            return true;
        }
        this.list.add(newNode);
        return true;
    }

    public Node searchBinary(String id) {
        Node node = null;
        if (id == null) {
            return null;
        }
        String idt = id.trim();
        if (idt.isEmpty()) {
            return null;
        }
        this.nodeSearchBinary.id = idt;
        int index = Collections.binarySearch(this.list, this.nodeSearchBinary, this.comparator);
        if (index >= 0) {
            node = this.list.get(index);
        }
        return node;
    }

    public Node searchNearest(Point2D.Double p, double maxdist) {
        return this.searchNearest(p.x, p.y, maxdist);
    }

    public Node searchNearest(double x, double y, double maxdist) {
        Node nearestNode = null;
        double mindist = maxdist;
        for (Node node : this.list) {
            double dist = node.distance(x, y);
            if (dist > maxdist || !(dist < mindist)) continue;
            mindist = dist;
            nearestNode = node;
        }
        return nearestNode;
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (Node node : this.list) {
            comp.addItem(node);
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Node node : this.list) {
            comp.add(node.toString());
        }
        return this.list.size();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("<nodes> <!-- The opening tag -->\n");
        for (Node node : this.list) {
            sb.append("   " + node.toXML());
        }
        sb.append("</nodes> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = "" + this.list.size() + " nodes";
        return s;
    }
}

