/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.NodeType;
import gatcomsumo.backend.TrafficLightType;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Node {
    public String id;
    public double x;
    public double y;
    public NodeType type;
    public String type_text;
    public TrafficLightType tl_type;
    public String tl_type_text;
    public String tl_id;
    public double radius;
    public ArrayList<Point2D.Double> shape;
    public boolean keepClear;
    public ArrayList<Edge> controlledInner;
    public ArrayList<Edge> edgesOut;

    public Node() {
        this.shape = new ArrayList();
        this.edgesOut = new ArrayList();
    }

    public Node(String id) {
        this(id, 0.0, 0.0, NodeType.priority);
    }

    public Node(String id, double x, double y) {
        this(id, x, y, NodeType.priority);
    }

    public Node(String id, double x, double y, NodeType type) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.type = type;
        this.shape = new ArrayList();
        this.edgesOut = new ArrayList();
    }

    public void addShapePoint(Point2D.Double p) {
        this.shape.add(p);
    }

    public void addControlledEdge(Edge edge) {
        this.controlledInner.add(edge);
    }

    public void addEdgeOut(Edge edge) {
        this.edgesOut.add(edge);
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<node id=\"" + this.id + "\" x=\"" + this.x + "\" y=\"" + this.y);
        sb.append("\" type=\"" + (Object)((Object)this.type) + "\"/>");
        sb.append(" <!-- def. of node \"" + this.id + "\"\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = this.id;
        return s;
    }

    public String getDescription() {
        String s = "ID=" + this.id + " at (" + this.x + "," + this.y + ")\n";
        s = s + "Type=" + this.type_text + "\n";
        if (this.edgesOut.size() > 0) {
            s = s + "Outgoing edges:";
            for (int i = 0; i < this.edgesOut.size(); ++i) {
                Edge edge = this.edgesOut.get(i);
                s = s + " " + edge.id;
            }
        }
        return s;
    }

    public double distance(Point2D.Double p) {
        double dist = Point.distance(this.x, this.y, p.x, p.y);
        return dist;
    }

    public double distance(double x, double y) {
        double dist = Point.distance(this.x, this.y, x, y);
        return dist;
    }
}

