/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import util.gps.UTMCoordinates;

public class NetworkLocation {
    public double offset_x = 0.0;
    public double offset_y = 0.0;
    public double bbox_west = 0.0;
    public double bbox_south = 0.0;
    public double bbox_east = 0.0;
    public double bbox_north = 0.0;
    public UTMCoordinates bbox_utm_sw;
    public UTMCoordinates bbox_utm_ne;
    public double bbox_conv_xmin = 0.0;
    public double bbox_conv_ymin = 0.0;
    public double bbox_conv_xmax = 0.0;
    public double bbox_conv_ymax = 0.0;
    public Rectangle2D.Double rectangle_bbox_conv;
    public String proj_parameters = "";
    public String proj_name = "utm";
    public int proj_zone_number = 30;
    public char proj_zone_letter = (char)78;
    public String proj_ellipsoid = "WGS84";
    public String proj_datum = "WGS84";
    public String proj_units = "m";

    public NetworkLocation() {
        this.rectangle_bbox_conv = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public void computeRect() {
        this.rectangle_bbox_conv = this.getRectangle_bbox_conv();
        this.compute_bbox();
    }

    public void compute_bbox() {
        double x = this.bbox_conv_xmin - this.offset_x;
        double y = this.bbox_conv_ymin - this.offset_y;
        this.bbox_utm_sw = new UTMCoordinates(this.proj_zone_number, this.proj_zone_letter, x, y);
        x = this.bbox_conv_xmax - this.offset_x;
        y = this.bbox_conv_ymax - this.offset_y;
        this.bbox_utm_ne = new UTMCoordinates(this.proj_zone_number, this.proj_zone_letter, x, y);
    }

    public Rectangle2D.Double getRectangle_bbox_conv() {
        Rectangle2D.Double r = new Rectangle2D.Double(this.bbox_conv_xmin, this.bbox_conv_ymin, this.bbox_conv_xmax - this.bbox_conv_xmin, this.bbox_conv_ymax - this.bbox_conv_ymin);
        return r;
    }

    public double getWidth_bbox_conv() {
        double width = this.bbox_conv_xmax - this.bbox_conv_xmin;
        return width;
    }

    public double getHeight_bbox_conv() {
        double height = this.bbox_conv_ymax - this.bbox_conv_ymin;
        return height;
    }

    public boolean inside(Point2D.Double p) {
        return this.inside(p.getX(), p.getY());
    }

    public boolean inside(double x, double y) {
        boolean insideY;
        boolean insideX = x >= this.bbox_conv_xmin && x <= this.bbox_conv_xmax;
        boolean bl = insideY = y >= this.bbox_conv_ymin && y <= this.bbox_conv_ymax;
        return insideX && insideY;
    }

    public boolean negativeEasting() {
        return this.bbox_east > this.bbox_west;
    }

    public boolean negativeNorthing() {
        return this.bbox_south > this.bbox_north;
    }
}

