/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Network;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import util.Util;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class NetworkBBox {
    private String name;
    private Network network;
    public UTMCoordinates utm_sw;
    public UTMCoordinates utm_ne;
    public GeodeticCoordinates geo_sw;
    public GeodeticCoordinates geo_ne;
    public Rectangle2D.Double bbox_utm;
    public Rectangle2D.Double bbox_conv;

    public NetworkBBox(String name, Network network) {
        this.name = name.trim();
        this.network = network;
        this.bbox_utm = new Rectangle2D.Double();
        this.bbox_conv = new Rectangle2D.Double();
    }

    public NetworkBBox(String name, Network network, UTMCoordinates utm_sw, UTMCoordinates utm_ne, double margin) {
        this(name, network);
        this.setBBox(utm_sw, utm_ne, margin);
    }

    public NetworkBBox(String name, Network network, GeodeticCoordinates geo_sw, GeodeticCoordinates geo_ne) {
        this(name, network);
        this.geo_sw = geo_sw;
        this.geo_ne = geo_ne;
        this.utm_sw = LatLongUTM.LLtoUTM(23, geo_sw);
        this.utm_ne = LatLongUTM.LLtoUTM(23, geo_ne);
        this.setBBox(this.utm_sw, this.utm_ne, 0.0);
    }

    public NetworkBBox(String name, Network network, double swlat, double swlon, double nelat, double nelon) {
        this(name, network);
        this.geo_sw = new GeodeticCoordinates(swlat, swlon);
        this.geo_ne = new GeodeticCoordinates(nelat, nelon);
        this.utm_sw = LatLongUTM.LLtoUTM(23, this.geo_sw);
        this.utm_ne = LatLongUTM.LLtoUTM(23, this.geo_ne);
        this.setBBox(this.utm_sw, this.utm_ne, 0.0);
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        String filename = (this.network != null ? this.network.id : this.name) + "_bbox.txt";
        return filename;
    }

    public boolean write_osm(String filename) {
        String text = "UTM-SW = " + this.fieldsUTM(this.utm_sw) + "\n";
        text = text + "UTM-NE = " + this.fieldsUTM(this.utm_ne) + "\n";
        text = text + "BBOX = " + this.fieldsBBox(this.bbox_utm) + "\n";
        boolean ok = Util.writeTextFile(filename, text);
        return ok;
    }

    public boolean read_osm() {
        BufferedReader br;
        FileReader fr;
        this.utm_sw = null;
        this.utm_ne = null;
        String filename_bbox = this.getFilename();
        File file = new File(filename_bbox);
        if (!file.exists()) {
            return false;
        }
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            System.err.println("Error al abrir fichero " + file);
            return false;
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("UTM-SW = ")) {
                    this.utm_sw = this.parseUTM(line);
                    continue;
                }
                if (line.startsWith("UTM-NE = ")) {
                    this.utm_ne = this.parseUTM(line);
                    continue;
                }
                if (!line.startsWith("BBOX")) continue;
                this.bbox_utm = NetworkBBox.parseBBox(line);
            }
            fr.close();
        }
        catch (IOException e) {
            return false;
        }
        this.computeBBox(this.utm_sw, this.utm_ne, 0.0);
        return true;
    }

    public void setBBox(UTMCoordinates utm_sw, UTMCoordinates utm_ne, double margin) {
        if (utm_sw == null || utm_ne == null) {
            return;
        }
        this.utm_sw = utm_sw;
        this.utm_ne = utm_ne;
        this.computeBBox(utm_sw, utm_ne, margin);
    }

    private Rectangle2D.Double computeBBox(UTMCoordinates utm_sw, UTMCoordinates utm_ne, double margin) {
        if (utm_sw == null || utm_ne == null) {
            return null;
        }
        this.bbox_utm.x = Math.min(utm_sw.x, utm_ne.x) - margin;
        this.bbox_utm.y = Math.min(utm_sw.y, utm_ne.y) - margin;
        this.bbox_utm.width = Math.abs(utm_sw.x - utm_ne.x) + margin * 2.0;
        this.bbox_utm.height = Math.abs(utm_sw.y - utm_ne.y) + margin * 2.0;
        this.geo_sw = LatLongUTM.UTMtoLL(23, utm_sw);
        this.geo_ne = LatLongUTM.UTMtoLL(23, utm_ne);
        if (this.network != null) {
            this.bbox_conv.x = this.bbox_utm.x + this.network.location.offset_x;
            this.bbox_conv.y = this.bbox_utm.y + this.network.location.offset_y;
            this.bbox_conv.width = this.bbox_utm.width;
            this.bbox_conv.height = this.bbox_utm.height;
        }
        return this.bbox_utm;
    }

    private String fieldsUTM(UTMCoordinates utm) {
        String s = utm.getZoneNumber() + ";" + utm.getZoneLetter() + ";" + utm.x + ";" + utm.y;
        return s;
    }

    private String fieldsBBox(Rectangle2D.Double bbox) {
        String s = bbox.x + ";" + bbox.y + ";" + bbox.width + ";" + bbox.height;
        return s;
    }

    private UTMCoordinates parseUTM(String line) {
        UTMCoordinates utm = null;
        String values = line.substring(line.indexOf("=") + 2);
        String[] args = values.split(";");
        if (args.length == 4) {
            int zoneNumber = Util.parseInt(args[0]);
            char zoneLetter = args[1].charAt(0);
            double x = Util.parseDouble(args[2]);
            double y = Util.parseDouble(args[3]);
            utm = new UTMCoordinates(zoneNumber, zoneLetter, x, y);
        }
        return utm;
    }

    private static Rectangle2D.Double parseBBox(String line) {
        Rectangle2D.Double bbox = null;
        String values = line.substring(line.indexOf("=") + 2);
        String[] args = values.split(";");
        if (args.length == 4) {
            double x = Util.parseDouble(args[0]);
            double y = Util.parseDouble(args[1]);
            double width = Util.parseDouble(args[2]);
            double height = Util.parseDouble(args[3]);
            bbox = new Rectangle2D.Double(x, y, width, height);
        }
        return bbox;
    }

    public String getString() {
        String s = "";
        if (this.bbox_utm != null) {
            s = s + "BBOX = " + this.fieldsBBox(this.bbox_utm) + "\n";
        }
        return s;
    }

    public String toString() {
        return this.name;
    }
}

