/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import gatcomsumo.backend.EdgeType;
import gatcomsumo.backend.EdgeTypes;
import gatcomsumo.backend.Edges;
import gatcomsumo.backend.Lane;
import gatcomsumo.backend.NetworkBBox;
import gatcomsumo.backend.NetworkLocation;
import gatcomsumo.backend.NetworkType;
import gatcomsumo.backend.Node;
import gatcomsumo.backend.Nodes;
import gatcomsumo.backend.SUMO;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.MyXML;
import util.Util;
import util.gps.GeodeticCoordinates;
import util.gps.LatLongUTM;
import util.gps.UTMCoordinates;

public class Network {
    public String id;
    public NetworkType type;
    public String filename_net;
    public Nodes nodes;
    public Edges edges;
    public EdgeTypes edgetypes;
    public NetworkLocation location;
    public NetworkBBox bbox;

    public Network() {
        this("map", NetworkType.OPENSTREETMAP);
    }

    public Network(String id, NetworkType type) {
        this.id = id.trim();
        this.type = type;
        this.nodes = new Nodes();
        this.edges = new Edges();
        this.edgetypes = new EdgeTypes();
        this.location = new NetworkLocation();
        this.bbox = new NetworkBBox(id, this);
    }

    public String toString() {
        String s = this.id;
        return s;
    }

    public boolean loaded() {
        return this.location.bbox_utm_sw != null && this.location.bbox_utm_ne != null;
    }

    public void init(String id, NetworkType type) {
        this.id = id.trim();
        this.type = type;
        this.nodes.list.clear();
        this.edges.list.clear();
        this.edgetypes.list.clear();
    }

    public boolean loadXML(String filename_xml) {
        String shape;
        String xmlID;
        int i;
        Element elementXML;
        this.init(this.id, NetworkType.UNKNOWN);
        this.filename_net = filename_xml;
        MyXML xml = new MyXML();
        if (!xml.open(filename_xml)) {
            return false;
        }
        String s = xml.getRoot();
        if (!s.equalsIgnoreCase("net")) {
            return false;
        }
        NodeList list = xml.getElements("location");
        if (list.getLength() > 0) {
            elementXML = MyXML.getElement(list, 0);
            if (elementXML != null) {
                s = elementXML.getAttribute("netOffset");
                String[] s_values = s.split(",");
                if (s_values.length == 2) {
                    this.location.offset_x = Double.parseDouble(s_values[0]);
                    this.location.offset_y = Double.parseDouble(s_values[1]);
                }
                if ((s_values = (s = elementXML.getAttribute("convBoundary")).split(",")).length == 4) {
                    this.location.bbox_conv_xmin = Double.parseDouble(s_values[0]);
                    this.location.bbox_conv_ymin = Double.parseDouble(s_values[1]);
                    this.location.bbox_conv_xmax = Double.parseDouble(s_values[2]);
                    this.location.bbox_conv_ymax = Double.parseDouble(s_values[3]);
                }
                if ((s_values = (s = elementXML.getAttribute("origBoundary")).split(",")).length == 4) {
                    this.location.bbox_west = Double.parseDouble(s_values[0]);
                    this.location.bbox_south = Double.parseDouble(s_values[1]);
                    this.location.bbox_east = Double.parseDouble(s_values[2]);
                    this.location.bbox_north = Double.parseDouble(s_values[3]);
                }
                if ((s_values = (s = elementXML.getAttribute("projParameter")).split("\\+")).length == 0) {
                    this.location.proj_parameters = s;
                } else {
                    for (int i2 = 0; i2 < s_values.length; ++i2) {
                        if (s_values[i2].startsWith("proj=")) {
                            this.location.proj_name = s_values[i2].substring("proj=".length()).trim();
                            continue;
                        }
                        if (s_values[i2].startsWith("zone=")) {
                            this.location.proj_zone_number = Integer.parseInt(s_values[i2].substring("zone=".length()).trim());
                            continue;
                        }
                        if (s_values[i2].startsWith("ellps=")) {
                            this.location.proj_ellipsoid = s_values[i2].substring("ellps=".length()).trim();
                            continue;
                        }
                        if (s_values[i2].startsWith("datum=")) {
                            this.location.proj_datum = s_values[i2].substring("datum=".length()).trim();
                            continue;
                        }
                        if (!s_values[i2].startsWith("units=")) continue;
                        this.location.proj_units = s_values[i2].substring("units=".length()).trim();
                    }
                }
                double middle_lat = (this.location.bbox_north + this.location.bbox_south) / 2.0;
                this.location.proj_zone_letter = LatLongUTM.UTMLetterDesignator(middle_lat);
            }
            this.location.computeRect();
            this.bbox = new NetworkBBox(this.id, this);
            boolean ok = this.bbox.read_osm();
            if (ok) {
                this.type = NetworkType.OPENSTREETMAP;
            } else {
                this.bbox.setBBox(this.location.bbox_utm_sw, this.location.bbox_utm_ne, 0.0);
            }
        }
        list = xml.getElements("type");
        int n = list.getLength();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(list, i);
            if (elementXML == null) continue;
            EdgeType edgetype = new EdgeType();
            this.edgetypes.list.add(edgetype);
            edgetype.id = MyXML.getParam(elementXML, "id", edgetype.id);
            edgetype.numlanes = MyXML.getParam(elementXML, "numLanes", edgetype.numlanes);
            edgetype.speed = MyXML.getParam(elementXML, "speed", edgetype.speed);
            edgetype.priority = MyXML.getParam(elementXML, "priority", edgetype.priority);
            edgetype.oneway = MyXML.getParam(elementXML, "oneway", edgetype.oneway);
            edgetype.discard = MyXML.getParam(elementXML, "discard", edgetype.discard);
            edgetype.sidewalkWidth = MyXML.getParam(elementXML, "sidewalkWidth", edgetype.sidewalkWidth);
            edgetype.disallowed_text = MyXML.getParam(elementXML, "disallow", edgetype.disallowed_text);
            edgetype.allowed_text = MyXML.getParam(elementXML, "allow", edgetype.allowed_text);
        }
        list = xml.getElements("edge");
        n = list.getLength();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(list, i);
            if (elementXML == null) continue;
            xmlID = MyXML.getParam(elementXML, "id", "");
            String function = MyXML.getParam(elementXML, "function", "");
            if (xmlID.charAt(0) == ':' || function.equalsIgnoreCase("internal")) continue;
            Edge edge = new Edge();
            this.edges.list.add(edge);
            edge.id = xmlID;
            edge.from = MyXML.getParam(elementXML, "from", edge.from);
            edge.to = MyXML.getParam(elementXML, "to", edge.to);
            edge.length = MyXML.getParam(elementXML, "length", edge.length);
            edge.type_text = MyXML.getParam(elementXML, "type", edge.type_text);
            edge.type = this.edgetypes.search(edge.type_text);
            shape = MyXML.getParam(elementXML, "shape", "");
            this.loadXML_shape(shape, edge.shape);
            edge.spread_type_text = MyXML.getParam(elementXML, "spread_type", edge.spread_type_text);
            edge.width = MyXML.getParam(elementXML, "width", edge.width);
            edge.name = MyXML.getParam(elementXML, "name", edge.name);
            edge.endOffset = MyXML.getParam(elementXML, "endOffset", edge.endOffset);
            edge.speed = MyXML.getParam(elementXML, "speed", edge.speed);
            edge.priority = MyXML.getParam(elementXML, "priority", edge.priority);
            edge.sidewalkWidth = MyXML.getParam(elementXML, "sidewalkWidth", edge.sidewalkWidth);
            edge.allowed_text = MyXML.getParam(elementXML, "allow", edge.allowed_text);
            edge.disallowed_text = MyXML.getParam(elementXML, "disallow", edge.disallowed_text);
            NodeList listLanes = xml.getSubElements(elementXML, "lane");
            int nLanes = edge.numlanes = listLanes.getLength();
            for (int j = 0; j < nLanes; ++j) {
                Element elementXMLLane = MyXML.getElement(listLanes, j);
                if (elementXMLLane == null) continue;
                Lane lane = new Lane();
                edge.lanes.add(lane);
                lane.id = MyXML.getParam(elementXMLLane, "id", lane.id);
                lane.index = MyXML.getParam(elementXMLLane, "index", lane.index);
                lane.speed = MyXML.getParam(elementXMLLane, "speed", lane.speed);
                lane.length = MyXML.getParam(elementXMLLane, "length", lane.length);
                lane.width = MyXML.getParam(elementXMLLane, "width", lane.width);
                lane.allowed_text = MyXML.getParam(elementXMLLane, "allow", lane.allowed_text);
                lane.disallowed_text = MyXML.getParam(elementXMLLane, "disallow", lane.disallowed_text);
                shape = MyXML.getParam(elementXMLLane, "shape", "");
                this.loadXML_shape(shape, lane.shape);
            }
        }
        list = xml.getElements("junction");
        n = list.getLength();
        for (i = 0; i < n; ++i) {
            elementXML = MyXML.getElement(list, i);
            if (elementXML == null || (xmlID = MyXML.getParam(elementXML, "id", "")).charAt(0) == ':') continue;
            Node node = new Node();
            node.id = xmlID;
            if (!this.nodes.insertSorted(node)) continue;
            node.x = MyXML.getParam(elementXML, "x", node.x);
            node.y = MyXML.getParam(elementXML, "y", node.y);
            node.type_text = MyXML.getParam(elementXML, "type", node.type_text);
            node.tl_type_text = MyXML.getParam(elementXML, "tl_type", node.tl_type_text);
            node.tl_id = MyXML.getParam(elementXML, "tl_id", node.tl_id);
            node.radius = MyXML.getParam(elementXML, "radius", node.radius);
            node.keepClear = MyXML.getParam(elementXML, "keepClear", node.keepClear);
            shape = MyXML.getParam(elementXML, "shape", "");
            this.loadXML_shape(shape, node.shape);
        }
        for (Edge edge : this.edges.list) {
            edge.fromNode = this.nodes.searchBinary(edge.from);
            edge.toNode = this.nodes.searchBinary(edge.to);
            edge.fromNode.addEdgeOut(edge);
        }
        return true;
    }

    private int loadXML_shape(String shape_text, ArrayList shape) {
        shape.clear();
        if (shape_text == null || shape_text.isEmpty()) {
            return 0;
        }
        String[] points = shape_text.split("\\s");
        for (int p = 0; p < points.length; ++p) {
            String[] values = points[p].split(",");
            if (values.length != 2) continue;
            double x = Util.parseDouble(values[0]);
            double y = Util.parseDouble(values[1]);
            Point2D.Double point = new Point2D.Double(x, y);
            shape.add(point);
        }
        return shape.size();
    }

    public Rectangle2D.Double buildBBOX_margin(SUMO sumo, double margin) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.x = Math.min(this.bbox.utm_sw.x, this.bbox.utm_ne.x) + this.location.offset_x - margin;
        r.y = Math.min(this.bbox.utm_sw.y, this.bbox.utm_ne.y) + this.location.offset_y - margin;
        r.width = Math.abs(this.bbox.utm_sw.x - this.bbox.utm_ne.x) + margin * 2.0;
        r.height = Math.abs(this.bbox.utm_sw.y - this.bbox.utm_ne.y) + margin * 2.0;
        return r;
    }

    public GeodeticCoordinates utm2lonlat(Point2D.Double pUTM, Point2D.Double pGeo) {
        UTMCoordinates utm = new UTMCoordinates(this.location.proj_zone_number, this.location.proj_zone_letter, pUTM.x, pUTM.y);
        GeodeticCoordinates geo = LatLongUTM.UTMtoLL(23, utm);
        pGeo.setLocation(geo.longitude, geo.latitude);
        return geo;
    }

    public GeodeticCoordinates utm2lonlat(UTMCoordinates utm, Point2D.Double pGeo) {
        GeodeticCoordinates geo = LatLongUTM.UTMtoLL(23, utm);
        pGeo.setLocation(geo.longitude, geo.latitude);
        return geo;
    }

    public UTMCoordinates lonlat2utm(Point2D.Double pGeo, Point2D.Double pUTM) {
        GeodeticCoordinates geo = new GeodeticCoordinates(pGeo.getY(), pGeo.getX());
        UTMCoordinates utm = LatLongUTM.LLtoUTM(23, geo);
        pUTM.setLocation(utm.x, utm.y);
        return utm;
    }

    public UTMCoordinates lonlat2utm(GeodeticCoordinates geo, Point2D.Double pUTM) {
        UTMCoordinates utm = LatLongUTM.LLtoUTM(23, geo);
        pUTM.setLocation(utm.x, utm.y);
        return utm;
    }

    public UTMCoordinates sumo2utm(Point2D.Double pSUMO, Point2D.Double pUTM) {
        double x = pSUMO.getX() - this.location.offset_x;
        double y = pSUMO.getY() - this.location.offset_y;
        pUTM.setLocation(x, y);
        UTMCoordinates utm = new UTMCoordinates(this.location.proj_zone_number, this.location.proj_zone_letter, pUTM.x, pUTM.y);
        return utm;
    }

    public void utm2sumo(Point2D.Double pUTM, Point2D.Double pSUMO) {
        double x = pUTM.getX() + this.location.offset_x;
        double y = pUTM.getY() + this.location.offset_y;
        pSUMO.setLocation(x, y);
    }

    public void utm2sumo(UTMCoordinates utm, Point2D.Double pSUMO) {
        double x = utm.x + this.location.offset_x;
        double y = utm.y + this.location.offset_y;
        pSUMO.setLocation(x, y);
    }

    public GeodeticCoordinates sumo2lonlat(Point2D.Double pSUMO, Point2D.Double pGeo) {
        Point2D.Double pUTM = new Point2D.Double(0.0, 0.0);
        this.sumo2utm(pSUMO, pUTM);
        GeodeticCoordinates geo = this.utm2lonlat(pUTM, pGeo);
        return geo;
    }

    public void lonlat2sumo(Point2D.Double pGeo, Point2D.Double pSUMO) {
        Point2D.Double pUTM = new Point2D.Double(0.0, 0.0);
        UTMCoordinates utm = this.lonlat2utm(pGeo, pUTM);
        this.utm2sumo(pUTM, pSUMO);
    }

    public void lonlat2sumo(GeodeticCoordinates geo, Point2D.Double pSUMO) {
        Point2D.Double pUTM = new Point2D.Double(0.0, 0.0);
        UTMCoordinates utm = this.lonlat2utm(geo, pUTM);
        this.utm2sumo(pUTM, pSUMO);
    }

    public void omnet2sumo(Point2D.Double pOmnet, Point2D.Double pSUMO) {
        double margin = 0.0;
        double x = pOmnet.getX() + this.location.bbox_conv_xmin - margin;
        double y = this.location.bbox_conv_ymax - this.location.bbox_conv_ymin - (pOmnet.getY() + this.location.bbox_conv_ymin) + margin;
        pSUMO.setLocation(x, y);
    }

    public void sumo2omnet(Point2D.Double pSUMO, Point2D.Double pOmnet) {
        double margin = 0.0;
        double x = pSUMO.getX() - this.location.bbox_conv_xmin + margin;
        double y = this.location.bbox_conv_ymax - this.location.bbox_conv_ymin - (pSUMO.getY() - this.location.bbox_conv_ymin) + margin;
        pOmnet.setLocation(x, y);
    }
}

