/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Lane {
    String id;
    int index;
    double speed;
    double length;
    public double width;
    ArrayList<Point2D.Double> shape;
    public String allowed_text;
    public String disallowed_text;

    public Lane() {
        this.shape = new ArrayList();
    }

    public Lane(String id, int index, double speed, double length) {
        this.id = id;
        this.index = index;
        this.speed = speed;
        this.length = length < 0.1 ? (double)0.1f : length;
        this.shape = new ArrayList();
    }

    public void addShapePoint(Point2D.Double p) {
        this.shape.add(p);
    }

    public boolean allowVehicleType(String name) {
        boolean allow = true;
        allow = this.allowed_text != null ? this.allowed_text.indexOf(name) >= 0 : (this.disallowed_text != null ? this.disallowed_text.indexOf(name) < 0 : true);
        return allow;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<lane id=\"" + this.id + "\" index=\"" + this.index + "\" speed=\"" + this.speed + "\" length=\"" + this.length + "\"");
        if (!this.shape.isEmpty()) {
            sb.append(" shape=\"");
            boolean first = true;
            for (Point2D point2D : this.shape) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                sb.append(point2D.getX() + "," + point2D.getY());
            }
            sb.append("\"");
        }
        if (this.allowed_text != null) {
            sb.append(" allow=\"");
            sb.append(this.allowed_text);
            sb.append("\"");
        }
        if (this.disallowed_text != null) {
            sb.append(" disallow=\"");
            sb.append(this.disallowed_text);
            sb.append("\"");
        }
        sb.append("/>\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = "" + this.id;
        return s;
    }

    public boolean insideBBOX(Rectangle2D.Double bbox) {
        for (Point2D.Double p : this.shape) {
            if (bbox.contains(p)) continue;
            return false;
        }
        return true;
    }

    public void getRectangle(Rectangle2D.Double r) {
        double xmin = r.x;
        double ymin = r.y;
        double xmax = r.x + r.width;
        double ymax = r.y + r.height;
        boolean first = r.width < 0.0 || r.height < 0.0;
        for (Point2D.Double p : this.shape) {
            if (first) {
                xmin = xmax = p.x;
                ymin = ymax = p.y;
                first = false;
                continue;
            }
            if (p.x < xmin) {
                xmin = p.x;
            }
            if (p.y < ymin) {
                ymin = p.y;
            }
            if (p.x > xmax) {
                xmax = p.x;
            }
            if (!(p.y > ymax)) continue;
            ymax = p.y;
        }
        r.x = xmin;
        r.y = ymin;
        r.width = xmax - xmin;
        r.height = ymax - ymin;
    }
}

