/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Flow;
import gatcomsumo.backend.FlowComparator;
import java.awt.List;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import util.Util;
import util.gui.MyTable;

public class Flows {
    public ArrayList<Flow> list = new ArrayList();
    private FlowComparator comparator = new FlowComparator();

    public Flow search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Flow flow : this.list) {
            if (!flow.id.equalsIgnoreCase(id)) continue;
            return flow;
        }
        return null;
    }

    public String getLastPrefix() {
        if (this.list.size() == 0) {
            return "flow";
        }
        Flow flow = this.list.get(this.list.size() - 1);
        String[] id = flow.id.split("-");
        if (id.length == 2) {
            return id[0];
        }
        return "flow";
    }

    public int getLastIndex(String prefix) {
        int maxIndex = -1;
        for (Flow flow : this.list) {
            int index;
            String[] id;
            if (flow.id.indexOf(45) < 0 || (id = flow.id.split("-")).length != 2 || !id[0].equalsIgnoreCase(prefix) || (index = Util.parseInt(id[1])) <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex;
    }

    public double getMaxBeginTime() {
        double lastBegin = -1.0;
        for (Flow flow : this.list) {
            if (!(flow.begin > lastBegin)) continue;
            lastBegin = flow.begin;
        }
        return lastBegin;
    }

    public void init() {
        this.list.clear();
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (Flow flow : this.list) {
            comp.addItem(flow.toString());
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Flow flow : this.list) {
            comp.add(flow.toString());
        }
        return this.list.size();
    }

    public int fill(MyTable table) {
        table.removeAllRows();
        int row = 0;
        for (Flow flow : this.list) {
            Object[] data = flow.buildRowTable(row);
            table.appendRow(data, true);
            ++row;
        }
        if (table.getNumRows() > 0) {
            table.selectRow(0);
        }
        return table.getNumRows();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("<flows> <!-- The opening tag -->\n");
        for (Flow flow : this.list) {
            sb.append("   " + flow.toXML());
        }
        sb.append("</flows> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = "" + this.list.size() + " flows";
        return s;
    }

    public void sortByStartTime() {
        Collections.sort(this.list, this.comparator);
    }

    public FlowComparator getComparator() {
        return this.comparator;
    }
}

