/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Route;
import gatcomsumo.backend.VehicleType;
import util.Colors;

public class Flow {
    public static final String[] FREQUENCY_FORMS = new String[]{"Vehicles per hour", "Period", "Probability"};
    public String id;
    public VehicleType type;
    public Colors color;
    public Route route;
    public int number;
    public double begin;
    public double end;
    public double vehsPerHour;
    public double period;
    public double probability;
    public static final String[] HEADERS = new String[]{"#", "ID", "Type", "Color", "Begin (s)", "End (s)", "Num. Vehicles", "Route"};
    public static final int[] NONEDITABLECOLS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public Flow() {
    }

    public Flow(String id, VehicleType type) {
        this(id, type, Colors.YELLOW, 1);
    }

    public Flow(String id, VehicleType type, Colors color, int number) {
        this.id = id;
        this.type = type;
        this.color = color;
        this.number = number;
    }

    public void setNumber(int number) {
        if (number > 0) {
            this.number = number;
        }
    }

    public void setBegin(double begin) {
        this.begin = begin;
    }

    public void setEnd(double end) {
        if (end > this.begin) {
            this.end = end;
        }
    }

    public void setRoute(Route route) {
        if (this.route != null) {
            this.route.removeFlow(this);
        }
        this.route = route;
        if (this.route != null) {
            this.route.addFlow(this);
        }
    }

    public void setFlowData(double begin, double end, double vehsPerHour, double period, double probability) {
        this.begin = begin;
        this.end = end;
        this.vehsPerHour = vehsPerHour;
        this.period = period;
        this.probability = probability;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<flow id=\"" + this.id + "\" type=\"" + this.type + "\" color=\"" + (Object)((Object)this.color) + "\"");
        sb.append(" number=\"" + this.number + "\"");
        sb.append(" begin=\"" + this.begin + "\"");
        if (this.vehsPerHour > 0.0) {
            sb.append(" vehsPerHour=\"" + this.vehsPerHour + "\" ");
        } else if (this.period > 0.0) {
            sb.append(" period=\"" + this.period + "\" ");
        } else if (this.probability > 0.0) {
            sb.append(" probability=\"" + this.probability + "\" ");
        } else {
            if (this.end <= this.begin) {
                this.end = this.begin + 1.0;
            }
            sb.append(" end=\"" + this.end + "\"");
        }
        if (this.route != null) {
            sb.append(" route=\"" + this.route.id + "\"");
        }
        sb.append("/>\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = this.id + " (begin=" + this.begin + ")";
        return s;
    }

    public Object[] buildRowTable(int row) {
        int ncols = HEADERS.length;
        Object[] data = new Object[ncols];
        data[0] = row + 1 + "";
        data[1] = this.id;
        data[2] = this.type;
        data[3] = this.color;
        data[4] = this.begin;
        data[5] = this.end;
        data[6] = this.number;
        data[7] = this.route;
        return data;
    }
}

