/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.Edge;
import java.awt.List;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;

public class Edges {
    public ArrayList<Edge> list;
    private Edge edgeSearchBinary;
    Comparator<Edge> comparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge o1, Edge o2) {
            return o1.id.compareTo(o2.id);
        }
    };

    public Edges() {
        this.edgeSearchBinary = new Edge();
        this.list = new ArrayList();
    }

    public Edge search(String id) {
        if (id == null) {
            return null;
        }
        String idt = id.trim();
        if (idt.isEmpty()) {
            return null;
        }
        for (Edge edge : this.list) {
            if (!edge.id.equalsIgnoreCase(idt)) continue;
            return edge;
        }
        return null;
    }

    public boolean insertSorted(Edge newEdge) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = this.list.get(i);
            int comp = edge.id.compareTo(newEdge.id);
            if (comp < 0) continue;
            if (comp == 0) {
                return false;
            }
            this.list.add(i, newEdge);
            return true;
        }
        this.list.add(newEdge);
        return true;
    }

    public Edge searchBinary(String id) {
        Edge edge = null;
        if (id == null) {
            return null;
        }
        String idt = id.trim();
        if (idt.isEmpty()) {
            return null;
        }
        this.edgeSearchBinary.id = idt;
        int index = Collections.binarySearch(this.list, this.edgeSearchBinary, this.comparator);
        if (index >= 0) {
            edge = this.list.get(index);
        }
        return edge;
    }

    public Edge random() {
        int numEdges = this.list.size();
        if (numEdges == 0) {
            return null;
        }
        int index = (int)(Math.random() * (double)numEdges);
        Edge edge = this.list.get(index);
        return edge;
    }

    public int searchAdjacents(Edge edgeRef, ArrayList<Edge> adj) {
        boolean n = false;
        if (edgeRef == null || adj == null) {
            return 0;
        }
        adj.clear();
        for (Edge edge : this.list) {
            if (edge == edgeRef || !edge.isAdjacent(edgeRef)) continue;
            adj.add(edge);
        }
        return adj.size();
    }

    public Edge searchNearest(Point2D.Double p, double distmax) {
        return this.searchNearest(p.x, p.y, distmax);
    }

    public Edge searchNearest(double x, double y, double distmax) {
        Edge nearestEdge = null;
        double distmin = distmax;
        for (Edge edge : this.list) {
            double dist = edge.distance(x, y);
            if (dist > distmax || !(dist < distmin)) continue;
            distmin = dist;
            nearestEdge = edge;
        }
        return nearestEdge;
    }

    public void clear() {
        this.list.clear();
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (Edge edge : this.list) {
            comp.addItem(edge);
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (Edge edge : this.list) {
            comp.add(edge.toString());
        }
        return this.list.size();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("<edges> <!-- The opening tag -->\n");
        for (Edge edge : this.list) {
            sb.append("   " + edge.toXML());
        }
        sb.append("</edges> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = "" + this.list.size() + " edges";
        return s;
    }
}

