/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.EdgeType;
import java.awt.List;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class EdgeTypes {
    public ArrayList<EdgeType> list = new ArrayList();

    public void clear() {
        this.list.clear();
    }

    public EdgeType search(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (EdgeType edgetype : this.list) {
            if (!edgetype.id.equalsIgnoreCase(id)) continue;
            return edgetype;
        }
        return null;
    }

    public int fill(JComboBox comp) {
        comp.removeAllItems();
        for (EdgeType edgetype : this.list) {
            comp.addItem(edgetype.toString());
        }
        return this.list.size();
    }

    public int fill(List comp) {
        comp.removeAll();
        for (EdgeType edgetype : this.list) {
            comp.add(edgetype.toString());
        }
        return this.list.size();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("<types> <!-- The opening tag -->\n");
        ArrayList<EdgeType> types = new ArrayList<EdgeType>();
        for (EdgeType edgetype : this.list) {
            if (edgetype == null || types.contains(edgetype)) continue;
            types.add(edgetype);
            sb.append("   " + edgetype.toXML());
        }
        sb.append("</types> <!-- The closing tag -->\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = "" + this.list.size() + " edge types";
        return s;
    }
}

