/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.VehicleType;
import java.util.ArrayList;

public class EdgeType {
    String id;
    int numlanes;
    double speed;
    int priority;
    boolean oneway;
    boolean discard;
    public double sidewalkWidth;
    public ArrayList<VehicleType> allowed;
    public String allowed_text;
    public ArrayList<VehicleType> disallowed;
    public String disallowed_text;

    public EdgeType() {
    }

    public EdgeType(String id, int numlanes, double speed, int priority) {
        this.id = id;
        this.numlanes = numlanes;
        this.speed = speed;
        this.priority = priority;
    }

    public void setOneway(boolean oneway) {
        this.discard = oneway;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public void setVehicleClassAllowed(String s) {
    }

    public void addVehicleClassAllowed(VehicleType type) {
        this.allowed.add(type);
    }

    public void addVehicleClassDisallowed(VehicleType type) {
        this.disallowed.add(type);
    }

    public String toXML() {
        boolean first;
        StringBuilder sb = new StringBuilder("");
        sb.append("<type id=\"" + this.id + "\" numlanes=\"" + this.numlanes + "\"");
        sb.append(" speed=\"" + this.speed + "\" priority=\"" + this.priority + "\"");
        sb.append(" oneway=\"" + this.oneway + "\" discard=\"" + this.discard + "\"");
        sb.append(" sidewalkWidth=\"" + this.sidewalkWidth + "\"");
        if (!this.allowed.isEmpty()) {
            sb.append(" allow=\"");
            first = true;
            for (VehicleType t : this.allowed) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                sb.append((Object)t.vClass);
            }
            sb.append("\"");
        }
        if (!this.disallowed.isEmpty()) {
            sb.append(" disallow=\"");
            first = true;
            for (VehicleType t : this.disallowed) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                sb.append((Object)t.vClass);
            }
            sb.append("\"");
        }
        sb.append("/>\n");
        String s = new String(sb);
        return s;
    }

    public String toString() {
        String s = this.id;
        return s;
    }
}

