/*
 * Decompiled with CFR 0.152.
 */
package gatcomsumo.backend;

import gatcomsumo.backend.EdgeSpreadLanes;
import gatcomsumo.backend.EdgeType;
import gatcomsumo.backend.Lane;
import gatcomsumo.backend.Node;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import util.gps.Navigation;

public class Edge {
    public String id;
    public String from;
    public Node fromNode;
    public String to;
    public Node toNode;
    public double length;
    public EdgeType type;
    public String type_text;
    public ArrayList<Point2D.Double> shape;
    public int numlanes;
    public ArrayList<Lane> lanes;
    public EdgeSpreadLanes spread_type;
    public String spread_type_text;
    public double width;
    public String name;
    public double endOffset;
    public double speed;
    public int priority;
    public double sidewalkWidth;
    public String allowed_text;
    public String disallowed_text;
    private static final String forbiddenChars = "_[] *:";
    private static final DecimalFormat f2 = new DecimalFormat("##0.00");
    public static final String[] HEADERS = new String[]{"#", "ID", "Length (m)", "Bearing", "Navigation instructions"};
    public static final int[] NONEDITABLECOLS = new int[]{0, 1, 2, 3, 4};

    public Edge() {
        this.lanes = new ArrayList();
        this.shape = new ArrayList();
    }

    public Edge(String id, String from, String to, int numlanes) {
        this(id, from, to, 1, 0);
    }

    public Edge(String id, String from, String to, int numlanes, int priority) {
        this.id = "";
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (forbiddenChars.indexOf(c) >= 0) continue;
            this.id = this.id + c;
        }
        this.from = from;
        this.to = to;
        this.numlanes = numlanes;
        this.priority = priority;
        this.lanes = new ArrayList();
        this.shape = new ArrayList();
    }

    public String getID() {
        return this.id;
    }

    public void addShapePoint(Point2D.Double p) {
        this.shape.add(p);
    }

    public void addLane(Lane lane) {
        this.lanes.add(lane);
        this.numlanes = this.lanes.size();
    }

    public boolean allowVehicleType(String name) {
        for (Lane lane : this.lanes) {
            if (!lane.allowVehicleType(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdjacent(Edge edge) {
        return edge.fromNode == this.toNode;
    }

    public int getAdjacents(ArrayList<Edge> edges) {
        edges.clear();
        for (Edge edge : this.toNode.edgesOut) {
            if (edge == this || edges.contains(edge)) continue;
            edges.add(edge);
        }
        return edges.size();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("");
        sb.append("<edge id=\"" + this.id + "\" from=\"" + this.from + "\" to=\"" + this.to + "\"");
        sb.append(" length=\"" + this.length + "\" spread_type=\"" + (Object)((Object)this.spread_type) + "\"");
        if (this.type == null) {
            sb.append(" numlanes=\"" + this.numlanes + "\" speed=\"" + this.speed + "\" priority=\"" + this.priority + "\"");
        } else {
            sb.append(" type=\"" + this.type.id + "\"");
        }
        if (!this.shape.isEmpty()) {
            sb.append(" shape=\"");
            boolean first = true;
            for (Point2D point2D : this.shape) {
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                sb.append(point2D.getX() + "," + point2D.getY());
            }
            sb.append("\"");
        }
        if (this.allowed_text != null) {
            sb.append(" allow=\"");
            sb.append(this.allowed_text);
            sb.append("\"");
        }
        if (this.disallowed_text != null) {
            sb.append(" disallow=\"");
            sb.append(this.disallowed_text);
            sb.append("\"");
        }
        if (!this.lanes.isEmpty()) {
            sb.append(">\n");
            for (Lane lane : this.lanes) {
                sb.append("   " + lane.toXML() + "\n");
            }
            sb.append(" </edge>\n");
        } else {
            sb.append("/>\n");
        }
        String s = new String(sb);
        return s;
    }

    public String toString() {
        double azimuth = this.getAzimuth();
        String s = this.id;
        s = s + " (" + f2.format(this.length()) + "m)";
        s = s + " / " + Navigation.getBearingString(azimuth);
        return s;
    }

    public String getDescription() {
        String s = "ID=" + this.id + " from node " + this.fromNode.id + " to " + this.toNode.id + "; length=" + this.length + "\n";
        s = s + "Type=" + this.type_text + ". Num. Lanes=" + this.numlanes + " speed=" + this.speed + " priority=" + this.priority + "\n";
        if (this.allowed_text != null && !this.allowed_text.isEmpty()) {
            s = s + " allowed=" + this.allowed_text + "\n";
        }
        if (this.disallowed_text != null && !this.disallowed_text.isEmpty()) {
            s = s + " disallowed_text=" + this.disallowed_text + "\n";
        }
        return s;
    }

    public double distance(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        return this.distance(p);
    }

    public double distance(Point2D.Double p) {
        double distmin;
        boolean bOk = false;
        Point2D.Double p1 = null;
        Point2D.Double p2 = null;
        int nPoints = this.shape.size();
        if (nPoints == 0) {
            p1 = new Point2D.Double(this.fromNode.x, this.fromNode.y);
            p2 = new Point2D.Double(this.toNode.x, this.toNode.y);
            distmin = this.distanceLinePoint(p1, p2, p, 10);
        } else {
            distmin = 999999.0;
            p1 = new Point2D.Double(this.fromNode.x, this.fromNode.y);
            for (int i = 0; !bOk && i < nPoints - 1; ++i) {
                p2 = this.shape.get(i);
                double dist = this.distanceLinePoint(p1, p2, p, 10);
                if (dist < distmin) {
                    distmin = dist;
                }
                p1 = p2;
                p2 = this.shape.get(i + 1);
            }
        }
        return distmin;
    }

    private double distanceLinePoint(Point2D.Double p1, Point2D.Double p2, Point2D.Double p, int margin) {
        double dist;
        int alto;
        int ancho;
        int y0;
        int x0;
        Rectangle rectangulo;
        if (margin <= 1) {
            margin = 1;
        }
        if (!(rectangulo = new Rectangle(x0 = (int)(Math.min(p1.x, p2.x) - (double)margin), y0 = (int)(Math.min(p1.y, p2.y) - (double)margin), ancho = (int)(Math.abs(p2.x - p1.x) + (double)(margin * 2)), alto = (int)(Math.abs(p2.y - p1.y) + (double)(margin * 2)))).contains(p)) {
            return 999999.0;
        }
        if (p2.x != p1.x) {
            double m = (p2.y - p1.y) / (p2.x - p1.x);
            x0 = (int)((m * (p.y - p1.y) + p.x + m * m * p1.x) / (m * m + 1.0));
            y0 = (int)(p1.y - m * p1.x + m * (double)x0);
            dist = Math.round(Math.sqrt(Math.pow(p.x - (double)x0, 2.0) + Math.pow(p.y - (double)y0, 2.0)));
        } else {
            dist = Math.abs(p.x - p1.x);
        }
        return dist;
    }

    public double length() {
        double len;
        if (this.length > 0.0) {
            len = this.length;
        } else {
            len = 0.0;
            if (this.lanes.size() > 0) {
                Lane lane = this.lanes.get(0);
                if (lane.length > 0.0) {
                    len += lane.length;
                }
            }
            this.length = len;
        }
        return len;
    }

    public boolean insideBBOX(Rectangle2D.Double bbox) {
        if (this.shape.size() == 0) {
            for (Lane lane : this.lanes) {
                if (lane.insideBBOX(bbox)) continue;
                return false;
            }
        } else {
            for (Point2D.Double p : this.shape) {
                if (bbox.contains(p)) continue;
                return false;
            }
        }
        return true;
    }

    public void getRectangle(Rectangle2D.Double r) {
        for (Lane lane : this.lanes) {
            lane.getRectangle(r);
        }
    }

    public double getAzimuth() {
        double azimuth = Navigation.getAzimuth(this.fromNode.x, this.fromNode.y, this.toNode.x, this.toNode.y);
        return azimuth;
    }

    public String getNavInstructions(Edge edge) {
        String navInstr = "";
        double azimuth0 = this.getAzimuth();
        int bearing0 = Navigation.getBearingSector(azimuth0);
        double azimuth1 = edge.getAzimuth();
        int bearing1 = Navigation.getBearingSector(azimuth1);
        navInstr = Navigation.getNavInstructions(bearing0, bearing1);
        return navInstr;
    }

    public Object[] buildRowTable(int row, Edge lastEdge) {
        String navInstr = "";
        int ncols = HEADERS.length;
        Object[] data = new Object[ncols];
        data[0] = row + 1 + "";
        data[1] = this.id;
        data[2] = String.format("%.2f", this.length());
        double azimuth = this.getAzimuth();
        data[3] = Navigation.getBearingString(azimuth);
        if (lastEdge != null) {
            navInstr = lastEdge.getNavInstructions(this);
        }
        data[4] = navInstr;
        return data;
    }
}

